<script type="text/javascript">
    var save_method; //for save method string
    var table;

    function reset_model() {
        $('#form')[0].reset(); // reset form on modals
        $('.err').html('');
        $('.message-container').fadeOut(3000);
        $('#product_img_div').hide();
        // $('#modal_form').modal('show'); // show bootstrap modal
        $('#seo-edit-modul').removeClass('seo-edit-modul-sow').addClass('seo-edit-modul-hide');
        // Reset TinyMCE editor
        if (typeof tinyMCE !== 'undefined' && tinyMCE.get('product_description_editor')) {
            tinyMCE.get('product_description_editor').setContent('');
        }
    }

    function add_product() {
        reset_model();
         $('#imageContainer').html("");
        save_method = 'add';
        $('#modal_form').modal('show'); // show bootstrap modal
        $('.modal-title').text('Add Product'); // Set Title to Bootstrap modal title
        set_seo_limit_suggestions();
        // Initialize TinyMCE if not already initialized
        if (typeof tinyMCE !== 'undefined' && !tinyMCE.get('product_description_editor')) {
            initCKeditor('#product_description_editor');
            setTimeout(attachProductEditorSync, 200);
        } else {
            setTimeout(attachProductEditorSync, 0);
        }
    }
function edit_product(id) {
    $('.spinner').show();
    reset_model();
    save_method = 'update';

    $.ajax({
        url: " <?php echo e(admin_url()); ?>products/" + id + "/edit/",
        type: "GET",
        success: function(data) {
            $('#imageContainer').html("");
            $('#brandLogoPreview').html(""); // clear brand logo container

            data = JSON.parse(data);
            $('[name="id"]').val(data.id);
            $('[name="product_name"]').val(data.product_name);
            $('[name="product_slug"]').val(data.product_slug);
            $('#sizes_colors').val(data.sizes_colors || '');

          
            const product_vs_ids = (data.product_vs_id) ? JSON.parse(data.product_vs_id) : [];
            
            if (Array.isArray(product_vs_ids)) {
                $('#product_vs_id').val(product_vs_ids).trigger('change');
            }
            $('[name="product_vs_id"]').val(product_vs_ids);

            // Product Color Image
            if (data.product_color_image) {
                $('#imageContainer').html(
                    `<img id="previewImage" src="<?php echo e(asset('uploads/products/')); ?>/${data.product_color_image}" 
                          alt="Preview" class="img-thumbnail" style="max-height:120px;">`
                );
            }

            // Set TinyMCE content
            setEditorHtml(data.product_description || '');
            (function setSliderDesc(){
                try {
                    if (typeof tinyMCE !== 'undefined') {
                        var ed = tinyMCE.get('slider_description_editor');
                        if (ed && ed.initialized) { ed.setContent(data.slider_description || ''); return; }
                        if (!ed) { try { initCKeditor('#slider_description_editor'); } catch(e) {} }
                    }
                } catch(e) {}
                setTimeout(setSliderDesc, 150);
            })();
            
            $('[name="price"]').val(data.price);
            
            if (data.selected_category_ids) {
                $('#category_ids').val(data.selected_category_ids).change();
            }
            
            fillSeoFields(data);

            // Featured image
            if (data.product_img != '') {
                var imgSrc = buildProductImageUrl(data.product_img);
                $('#product_img_div').show();
                $('#product_img_div').html(
                    '<img style="width:100px; height:auto; display:block; border:1px solid #ccc;" src="' + imgSrc +
                    '"><i onclick="remove_products_image(' + data.id + ');" class="deleteIcon"></i>'
                );
            } else {
                $('#product_img_div').hide();
            }

            $('[name="product_img_title"]').val(data.product_img_title);
            $('[name="product_img_alt"]').val(data.product_img_alt);

            // ✅ Handle Brand Logo

            if (data.brand_logo_image) {
                $('#brandLogoPreview').html(
                    `<img id="brandLogoImagePreview" src="<?php echo e(asset('uploads/products/')); ?>/${data.brand_logo_image}" 
                          alt="Preview" class="img-thumbnail" style="max-height:120px;">`
                );
            }

            // Product slider images
            try {
                $('#product_extra_images_container').empty();
                if (Array.isArray(data.product_extra_images) && data.product_extra_images.length) {
                    renderProductExtraImages(data.product_extra_images);
                }
            } catch(e) {}

            $('.spinner').hide();
            $('#modal_form').modal('show');
            $('.modal-title').text('Edit Product');
        },
        error: function(jqXHR, textStatus, errorThrown) {
            alert('Error get data from ajax');
            console.log(jqXHR);
            console.log(textStatus);
            console.log(errorThrown);
        }
    });
}


    function save() {
        // Sync editor content into form fields before submit
        if (typeof tinyMCE !== 'undefined') {
            try { tinyMCE.triggerSave(); } catch (e) {}
        }
        // Get TinyMCE content and set it to hidden field used by backend
        if (typeof tinyMCE !== 'undefined' && tinyMCE.get('product_description_editor')) {
            var content = tinyMCE.get('product_description_editor').getContent();
            $('#product_description1').val(content);
            // Also set the named textarea directly so regular form submit picks it up
            $("textarea[name='product_description']").val(content);
            try { console.log('Submitting product_description length:', (content||'').length); } catch(e) {}
        }
        // Sync slider description editor
        if (typeof tinyMCE !== 'undefined' && tinyMCE.get('slider_description_editor')) {
            var scontent = tinyMCE.get('slider_description_editor').getContent();
            $('#slider_description').val(scontent);
        }
        
        let url;
        if (save_method === 'add') {
            url = "<?php echo e(base_url() . 'adminmedia/products'); ?>";
            method = 'POST';
            header = '';
        } else {
            id = $('[name="id"]').val();
            url = "<?php echo e(base_url() . 'adminmedia/products/'); ?>" + id;
            console.log(id);
            console.log(url);
            method = 'POST';
            header = {
                "X-HTTP-Method-Override": "PUT"
            };
        }
        let formData = new FormData($('#form')[0]);
        // Ensure product_description is present on FormData
        var pd = $('#product_description1').val();
        try { formData.delete('product_description'); } catch(e) {}
        formData.append('product_description', pd);
        // Ensure slider_description is present
        var sd = $('#slider_description').val();
        try { formData.delete('slider_description'); } catch(e) {}
        formData.append('slider_description', sd);
        console.log(formData);
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        $.ajax({
            url: url,
            type: method,
            data: formData,
            // dataType: "JSON",
            headers: header,
            async: true,
            cache: false,
            contentType: false,
            processData: false,
            success: function(data) {
                console.log(data);
                data = JSON.parse(data);
                if (data.status) {
                    $('#modal_form').modal('hide');
                    location.reload();
                } else {
                    $('.error-div').html('');
                    $('.error-div').show();
                    $('.error-div').html(data.errors);
                    // $('#product_name').html('Validation Error, ' + data.errors)[0];
                }
            },
            error: function(jqXHR, textStatus, errorThrown) {
                alert('Error adding / update data ' + ' ' + textStatus + ' ' + errorThrown);
                console.log(jqXHR);
                console.log(textStatus);
                console.log(errorThrown);
            }
        });
    }

    function delete_product(id) {
        $('.message-container').fadeOut(3000);
        if (confirm('Are you sure delete this data?')) {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: "<?php echo e(admin_url() . 'products/'); ?>" + id,
                type: "DELETE",
                success: function(data) {
                    //if success reload ajax table
                    location.reload();
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    alert('Error adding / update data ' + ' ' + textStatus + ' ' + errorThrown);
                }
            });
        }
    }

    function remove_products_image(id) {
        if (confirm("Are you sure you want to delete this Product Image?")) {
            // ajax delete data to database
            $.ajax({
                url: base_url + "adminmedia/products/ajax_remove_feature_image/" + id,
                type: "GET",
                dataType: "JSON",
                success: function(data) {
                    $('#product_img_div').hide();
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    alert('Error adding / update data ' + ' ' + textStatus + ' ' + errorThrown);
                }
            });
        }
    }
    $(function() {
        $('#sortable').sortable({
            axis: 'y',
            opacity: 0.7,
            handle: 'span',
            update: function(event, ui) {
                var list_sortable = $(this).sortable('toArray').toString();
                // change order in the database using Ajax
                console.log(list_sortable);
                $.ajax({
                    url: base_url + 'adminmedia/products/create',
                    type: 'GET',
                    data: {
                        list_order: list_sortable
                    },
                    success: function(data) {
                        //finished
                        console.log(data);
                    },
                    error: function(jqXHR, textStatus, errorThrown) {
                        alert('Error adding / update data ' + ' ' + textStatus + ' ' +
                            errorThrown);
                        console.log(jqXHR);
                        console.log(textStatus);
                        console.log(errorThrown);
                    }
                });
            }
        }); // fin sortable
    });

    function update_product_sts_toggle(id) {
        var current_status = 'notset';
        var myurl = base_url + 'adminmedia/products/' + id + '?status=' + current_status;
        $.get(myurl, function(sts) {
            alertme('<i class="fas fa-check" aria-hidden="true"></i> Done Successfully ',
                'success', true, 1500);
        });
    }

    function showProductRecordUpdateHistory() {
        let id = $('#id').val();
        window.location.href = base_url + 'adminmedia/record-update-history/Product/' + id;
    }
    $(document).ready(function() {
        <?php if(request()->input('id', 0) > 0): ?>
            edit_product(<?php echo e(request()->input('id', 0)); ?>);
        <?php endif; ?>
        setTimeout(attachProductEditorSync, 300);
    });

    // Media insertion functions
    function media_insert_img(url) {
        insertImageIntoCkeditor('product_description_editor', url);
        $("#media_image").modal('hide');
    }

    function media_insert_file(url) {
        $("#file_c_url").val(url);
        $("#media_files").modal('hide');
        $("#modal_file_link_text").modal('show');
    }

    function insert_media_file_html() {
        var url = $("#file_c_url").val();
        var linktxt = $("#link_on_text").val();
        tinyMCE.get('product_description_editor').execCommand('mceInsertContent', false, '<a href="'+url+'">'+linktxt+'</a>' );
        $("#modal_file_link_text").modal('hide');
    }

    function show_section(idd, objj) {
        $(".fldbtns").removeClass('active');
        $(objj).addClass('active');
        $(".mystr").parent('.mediaup').hide();
        $(".section_" + idd).parent('.mediaup').show();
    }


</script>
<script type="text/javascript">
// Allow typing/clicking inside TinyMCE dialogs when inside Bootstrap modal
$(document).on('focusin', function(e) {
    if ($(e.target).closest('.tox-tinymce, .tox-dialog, .moxman-window, .tam-assetmanager-root').length) {
        e.stopImmediatePropagation();
    }
});

// Keep hidden textarea synchronized with TinyMCE content at all times
function attachProductEditorSync() {
    if (typeof tinyMCE === 'undefined') return;
    var ed = tinyMCE.get('product_description_editor');
    if (!ed) return;
    if (ed._ml_sync_bound) return; // avoid double-binding
    ed._ml_sync_bound = true;
    var sync = function() {
        var html = ed.getContent();
        $('#product_description1').val(html);
        $("textarea[name='product_description']").val(html);
    };
    ed.on('init', sync);
    ed.on('change keyup input undo redo SetContent', sync);
}

// Utility: set editor HTML once TinyMCE is ready
function setEditorHtml(html) {
    if (typeof tinyMCE === 'undefined') {
        initCKeditor('#product_description_editor');
    }
    var attempt = 0;
    (function waitAndSet(){
        attempt++;
        var ed = (typeof tinyMCE !== 'undefined') ? tinyMCE.get('product_description_editor') : null;
        if (ed && ed.initialized) {
            ed.setContent(html);
            $('#product_description1').val(html);
            $("textarea[name='product_description']").val(html);
            attachProductEditorSync();
        } else {
            if (attempt < 40) { // up to ~4s
                if (!ed) { try { initCKeditor('#product_description_editor'); } catch(e) {} }
                setTimeout(waitAndSet, 100);
            }
        }
    })();
}

// Build absolute product image URL from stored filename/path
function buildProductImageUrl(stored) {
    if (!stored) return '';
    // If already absolute URL
    if (/^https?:\/\//i.test(stored)) return stored;
    // If stored already contains a folder e.g. 'products/foo.jpg' or 'module/products/foo.jpg'
    if (stored.indexOf('/') !== -1) {
        return asset_uploads + stored.replace(/^\/+/, '');
    }
    // Default: assume plain filename in products folder
    // Ensure proper path construction with trailing slash
    var baseUrl = asset_uploads.endsWith('/') ? asset_uploads : asset_uploads + '/';
    return baseUrl + 'products/' + stored;
}




// ------- Image preview helpers -------
function makeImagePreview(fileInput, containerSelector) {
  const container = document.querySelector(containerSelector);
  if (!container) return;
  container.innerHTML = '';
  const files = fileInput.files || [];
  if (!files.length) return;
  const file = files[0];
  const reader = new FileReader();
  reader.onload = function(e) {
    const img = document.createElement('img');
    img.src = e.target.result;
    img.style.maxWidth = '180px';
    img.style.height = 'auto';
    img.style.border = '1px solid #ccc';
    img.style.borderRadius = '6px';
    container.appendChild(img);
  };
  reader.readAsDataURL(file);
}

// Bind change listeners once DOM is ready
$(document).ready(function() {
  const colorInput = document.getElementById('imageUpload');
  const brandInput = document.getElementById('brandImage');
  if (colorInput) {
    colorInput.addEventListener('change', function() {
      makeImagePreview(this, '#productColorPreview');
    });
  }
  if (brandInput) {
    brandInput.addEventListener('change', function() {
      makeImagePreview(this, '#brandLogoPreview');
    });
  }
});





</script>
<?php /**PATH /home/native33/public_html/client/surfacestatement/resources/views/back/product/product_js.blade.php ENDPATH**/ ?>