
<?php $__env->startSection('content'); ?>
    <div class="content-wrapper pl-3 pr-2">
        <section class="content-header">
            <div class="row">
                <div class="col-md-5 col-sm-12">
                    <ol class="breadcrumb">
                        <li><a href="<?php echo e(admin_url()); ?>"><i class="fas fa-tachometer-alt"></i> Home</a></li>
                        <li class="active">Manage Admin Users</li>
                    </ol>
                </div>
                <div class="col-md-7 col-sm-12">
                    <?php echo $__env->make('back.common_views.quicklinks', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </div>
        </section>
        <section class="content">
            <div class="row">
                <?php if($errors->any()): ?>
                    <div class="alert alert-danger">
                        <ul>
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                <?php endif; ?>                
                <div class="col-md-12">
                    <div class="box box-primary">
                        <div class="box-header">
                            <h3 class=" card-title">Edit Admin User</h3>
                        </div>
                        <form role="form" method="post" action="<?php echo e(route('admin.update',$user->id)); ?>">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="_method" value="PUT">
                            <input type="hidden" name="id" value="<?php echo e($user->id); ?>">
                            <div class=" card-body">
                                <div class="form-group">
                                    <label for="admin_name">Name</label>
                                    <input type="text" class="form-control" id="admin_name" name="admin_name" required
                                           value="<?php echo e($user->name); ?>">
                                </div>
                                <div class="form-group">
                                    <label for="admin_email">Email</label>
                                    <input type="text" class="form-control" id="admin_email" name="admin_email" required
                                           value="<?php echo e($user->email); ?>">
                                </div>
                                <div class="form-group">
                                    <label for="password">Password</label>
                                    <input type="password" class="form-control" id="password" name="password"
                                           value="<?php echo e(''); ?>">
                                </div>
                                <div class="form-group">
                                    <label for="type">type</label>
                                    <select class="form-control" id="type" name="type">
                                        <option value=""></option>
                                        <option value="<?php echo e(config('Constants.USER_TYPE_SUPER_ADMIN')); ?>" <?php echo e(($user->type == config('Constants.USER_TYPE_SUPER_ADMIN'))? 'selected="selected"':''); ?>>Super Level</option>
                                        <option value="<?php echo e(config('Constants.USER_TYPE_NORMAL_ADMIN')); ?>" <?php echo e(($user->type == config('Constants.USER_TYPE_NORMAL_ADMIN'))? 'selected="selected"':''); ?>>Mid Level</option>
                                        <option value="<?php echo e(config('Constants.USER_TYPE_REPS_ADMIN')); ?>" <?php echo e(($user->type == config('Constants.USER_TYPE_REPS_ADMIN'))? 'selected="selected"':''); ?>>Reps</option>
                                    </select>
                                </div>
                            </div>
                            <div class="box-footer">
                                <input type="submit"  name="save" value="Add User" class="btn btn-primary">
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('back.layouts.app',['title' => $title], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/surfacest2025/site_files/resources/views/back/users/admin/edit.blade.php ENDPATH**/ ?>