<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-body login-card-body">
            <p class="login-box-msg"><?php echo e(__('Login')); ?></p>

            <form method="POST" action="<?php echo e(route('admin.login')); ?>">
                <?php echo csrf_field(); ?>
                <div class="input-group mb-3">
                    <input id="email" type="email" class="form-control <?php echo e(hasError($errors, 'email')); ?>" name="email"
                        value="<?php echo e(old('email')); ?>" required autocomplete="email" autofocus>
                    <div class="input-group-append">
                        <div class="input-group-text">
                            <span class="fas fa-envelope"></span>
                        </div>
                    </div>
                    <?php echo showErrors($errors, 'email'); ?>

                </div>
                <div class="input-group mb-3">
                    <input id="password" type="password" class="form-control <?php echo e(hasError($errors, 'password')); ?>"
                        name="password" required autocomplete="current-password">
                    <div class="input-group-append">
                        <div class="input-group-text">
                            <span class="fas fa-eye-slash mr-1" onclick="showHidePassword('password', 'eye_icon');" id="eye_icon"></span>
                            <span class="fas fa-lock"></span>
                        </div>
                    </div>
                    <?php echo showErrors($errors, 'password'); ?>

                </div>
                <div class="row">
                    <div class="col-8">
                        <div class="icheck-primary">
                            <input type="checkbox" name="remember" id="remember" <?php echo e(old('remember') ? 'checked' : ''); ?>>
                            <label for="remember">
                                <?php echo e(__('Remember Me')); ?>

                            </label>
                        </div>
                    </div>
                    <!-- /.col -->
                    <div class="col-4">
                        <button type="submit" class="btn btn-primary btn-block"><?php echo e(__('Login')); ?></button>
                    </div>
                    <!-- /.col -->
                </div>
            </form>
            <?php if(Route::has('password.request')): ?>
                <p class="mb-1">
                    <a href="<?php echo e(route('admin.password.request')); ?>">
                        <?php echo e(__('Forgot Your Password?')); ?>

                    </a>
                </p>
            <?php endif; ?>
        </div>
        <!-- /.login-card-body -->
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('beforeBodyClose'); ?>
<script>
    function showHidePassword(fieldId, eyeId){
        if($('#'+fieldId).attr('type') == 'password'){
            $('#'+fieldId).attr('type', 'text');
            $('#'+eyeId).removeClass('fa-eye-slash');
            $('#'+eyeId).addClass('fa-eye');
        }else{
            $('#'+fieldId).attr('type', 'password');
            $('#'+eyeId).removeClass('fa-eye');
            $('#'+eyeId).addClass('fa-eye-slash');
        }
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.backend.guest', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/surfacest2025/site_files/resources/views/admin_auth/login.blade.php ENDPATH**/ ?>