
<?php $__env->startSection('beforeHeadClose'); ?>
<?php echo $__env->make('back.common_views.switch_css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<style>
    .select2-container{
      width: 100% !important;  
    }
    .select2-selection {
    min-height: 40px;
}
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="pl-3 pr-2 content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="row">
                <div class="col-md-5 col-sm-12">
                    <ol class="breadcrumb">
                        <li>
                            <a href="<?php echo e(admin_url()); ?>">
                                <i class="fas fa-gauge"></i> Home
                            </a>
                        </li>
                        <li class="active">Product's Management</li>
                    </ol>
                </div>
                <div class="col-md-7 col-sm-12">
                    <?php echo $__env->make('back.common_views.quicklinks', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </div>
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-xs-12 col-md-12">
                    <div class="p-2 card">
                        <div class="row">
                            <div class="col-sm-8">
                                <div class="box-header">
                                    <h3 class=" card-title">All Products</h3>
                                </div>
                            </div>
                            <div class="col-sm-4">
                                <div class="text-end" style="padding-bottom:2px;">
                                    <input type="button" class="sitebtn" value="Add Product" onclick="add_product()" />
                                </div>
                            </div>
                        </div>
                        <!-- /.box-header -->
                        <div class=" card-body table-responsive">
                            <table id="table" class="table table-bordered table-hover">
                                <thead>
                                    <tr>
                                        <th>Date</th>
                                        <th>Product Name</th>
                                        
                                        <th>Categories</th>
                                        
                                        <th>Status</th>
                                        <th>Is Featured</th>
                                        <th>Action</th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody id="sortable">
                                    <?php $__empty_1 = true; $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr id="<?php echo e($product->id); ?>">
                                            <td><?php echo e(format_date($product->dated, 'date')); ?></td>
                                            <td><?php echo e($product->product_name); ?></td>
                                            
                                            <td>
                                                <?php
                                                    $cats = [];
                                                    try { $cats = $product->categories()->pluck('title')->toArray(); } catch (\Throwable $e) { $cats = []; }
                                                ?>
                                                <?php echo e(empty($cats) ? '-' : implode(', ', $cats)); ?>

                                            </td>
                                            

                                            <td>
                                                <label class="switch">
                                                    <input type="checkbox" name="<?php echo e('pro_sts_' . $product->id); ?>"
                                                        id="<?php echo e('pro_sts_' . $product->id); ?>" <?php echo $product->sts == 1 ? ' checked' : ''; ?>
                                                        value="<?php echo !empty($product->sts)? $product->sts:'blocked' ; ?>"
                                                        onClick="update_product_sts_toggle(<?php echo e($product->id); ?>)">
                                                    <div class="slider round">
                                                        <strong class="on">Active</strong>
                                                        <strong class="off">Inactive</strong>
                                                    </div>
                                                </label>
                                            </td>
                                        <td>
    <?php if($product->is_featured == 'Yes'): ?>
        <a href="javascript:;"
            class="btn-success btn-sm make_featured_class_<?php echo e($product->id); ?>"
            onclick="featured_change('<?php echo e($product->id); ?>')">
            <i class="fa fa-star" aria-hidden="true"></i>
        </a>
    <?php else: ?>
        <a href="javascript:;"
            class="btn-danger btn-sm make_featured_class_<?php echo e($product->id); ?>"
            onclick="featured_change('<?php echo e($product->id); ?>')">
            <i class="fa fa-star" aria-hidden="true"></i>
        </a>
    <?php endif; ?>
</td>

                                            
                                            

                                            <td>
                                                <a class="btn btn-sm btn-primary" href="javascript:void(0);" title="Edit"
                                                    onclick="edit_product(<?php echo e($product->id); ?>)">
                                                    
                                                    <i class="glyphicon glyphicon-pencil"></i> Edit</a>
                                                    
                                                    
                                                <a class="btn btn-sm btn-danger" href="javascript:void(0);" title="Delete"
                                                    onclick="delete_product(<?php echo e($product->id); ?>)">
                                                    <i class="glyphicon glyphicon-trash"></i> Delete</a>
                                                    
                                                    
                                                    
                                         <a class="btn btn-sm btn-primary" href="/adminmedia/module/product-colors?id=<?php echo e($product->id); ?>" title="Manage Colors"
                                        >
                                                    <i class="glyphicon glyphicon-palette"></i> Manage Colors</a> 
                                                    
                                       
                                                    
                                                
                                            </td>
                                            <td align="center">
                                                <span></span>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td colspan="4" align="center" class="text-red">No Record found!</td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                                <tfoot></tfoot>
                            </table>
                        </div>
                        <!-- /. card-body -->
                    </div>
                    <!-- /.box -->
                    <!-- /.box -->
                </div>
            </div>
        </section>
        <!-- /.content -->
    </div>
    
<?php $__env->stopSection(); ?>
<?php $__env->startSection('beforeBodyClose'); ?>
    <script src="<?php echo e(asset_storage('') . 'module/products/admin/js/products.js'); ?>" type="text/javascript"></script>
    <script>
        var uploadUrl = "<?php echo e(admin_url()); ?>module_image/upload_image";
        var deleteUrl = "<?php echo e(admin_url()); ?>module_image/remove_image";
        var folder = "products";
        var maxSize = <?php echo e(getMaxUploadSize()); ?>;
        var csrfToken = $('meta[name="csrf-token"]').attr('content');
        var show_cropper = false;
    </script>
    <script type="text/javascript" src="<?php echo e(asset_storage('') . 'back/js/fileUploader.js'); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset_storage('') . 'module/settings/admin/js/settings.js'); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset_storage('')); ?>back/mod/mod_js.js"></script>
    <?php echo $__env->make('back.product.product_js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('back.product.add_edit_view', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <script type="text/javascript">
        $('.website_product_sell').click(function() {
            var product_Sale_Status = $(this).val();
            $.ajax({
                url: '<?php echo e(route('product.sell.status')); ?>',
                method: 'get',
                data: {
                    "_token": "<?php echo e(csrf_token()); ?>",
                    " product_Sale_Status": product_Sale_Status
                },
                success: function(response) {
                    alertme('<i class="fas fa-check" aria-hidden="true"></i> Done Successfully ',
                        'success', true, 1500);
                }
            });
        });
    </script>
    
    
<script>
function featured_change(id) {
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    $.ajax({
        url: "<?php echo e(route('product.featured', ['id' => ':id'])); ?>".replace(':id', id),
        type: "get",
        success: function(data) {
            if (data.status == "success") {
                if (data.res == 1) {
                    $(".make_featured_class_" + id).addClass('btn-success').removeClass('btn-danger');
                } else {
                    $(".make_featured_class_" + id).removeClass('btn-success').addClass('btn-danger');
                }

                alertme('<i class="fa fa-check" aria-hidden="true"></i> Done Successfully ',
                    'success', true, 1500);

            } else {
                alert('Error adding / update data');
            }
        },
        error: function(jqXHR, textStatus, errorThrown) {
            alert('Error adding / update data');
            console.log(jqXHR);
            console.log(textStatus);
            console.log(errorThrown);
        }
    });
}
</script>

<script>
function alertme(text, type, autoClose, closeAfterSec)
 
    {
 
        var type = type || 'success';
 
        var autoClose = autoClose || true;
 
        var closeAfterSec = closeAfterSec || 2000;
 
        $(".alertme").hide();
 
        var mhtml =
            '<div class="alertme text-center" id="div_alert" style="margin:5px;top:3%;position:fixed;z-index:9999;width:100%">' +
 
            '<div style="max-width: 400px;margin: 0 auto;" class="alert alert-' + type +
            ' alert-dismissible"> <button type="button" class="close" data-dismiss="alert">&times;</button> ' + text +
            '</div></div>';
 
        $("body").append(mhtml);
 
        if (autoClose) {
 
            setTimeout(function() {
                $(".alertme").hide();
            }, closeAfterSec);
 
        }
    }
    
    
    // Reset modal whenever it opens
$('#modal_form').on('hidden.bs.modal', function () {

    $('#imageContainer').html("");
    $('#product_img_div').hide().html("");
    $('#product_extra_images_container').html("");
     $('#brandLogoPreview').html("");
    $('#product_vs_id').val(null).trigger('change'); 

});

$(document).ready(function() {
    $('#product_vs_id').select2();
});
    
</script>
    
<?php $__env->stopSection(); ?>

<?php echo $__env->make('back.layouts.app', ['title' => $title], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/native33/public_html/client/surfacestatement/resources/views/back/product/index.blade.php ENDPATH**/ ?>