<?php $__env->startSection('content'); ?>
    <div class="pl-3 pr-2 content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="row">
                <div class="col-md-5 col-sm-12">
                    <ol class="breadcrumb">
                        <li>
                            <a href="<?php echo e(base_url() . 'adminmedia'); ?>">
                                <i class="fas fa-tachometer-alt"></i> Home
                            </a>
                        </li>
                        <li class="active">
                            <a href="<?php echo e(base_url() . 'adminmedia/blog-posts'); ?>">
                                Blog Management
                            </a>
                        </li>
                    </ol>
                </div>
                <div class="col-md-7 col-sm-12">
                    <?php echo $__env->make('back.common_views.quicklinks', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </div>
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-xs-12 col-md-12">
                    <div class="p-2 card">
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="box-header">
                                    <h3 class=" card-title">Blog Posts</h3>
                                </div>
                            </div>
                        </div>
                        <!-- /.box-header -->
                        <div class=" card-body table-responsive">
                            <form method="post" id="blog-search-form">
                                <div class="mb-3 row">
                                    <div class="col-lg-4">

                                        <button type="button" class="btn btn-sm btn-info" onclick="showFilters();"
                                            id="showFilterbtn btn-sm">Show
                                            Filters</button>
                                        <button type="button" class="btn btn-sm btn-warning" onclick="hideFilters();"
                                            id="hideFilterbtn btn-sm" style="display: none;">Hide Filters</button><br><br>
                                    </div>

                                    <div class="col-sm-8 text-end">
                                        <div class="text-end" style="padding-bottom:2px;">
                                            <a href="<?php echo e(admin_url() . 'blog-categories'); ?>" class="btn btn-sm btn-warning">Categories</a>
                                            <a href="<?php echo e(route('blog.post.create')); ?>" class="btn btn-sm btn-success">Add Blog Post</a>
                                        </div>
                                    </div>

                                </div>

                                <div class="mb-3 row" id="filterForm" style="display: none;">
                                    <div class="col-md-3 form-group">
                                        <label>Search</label>
                                        <input id="search" name="search" type="text" placeholder="Search"
                                            value="<?php echo e(request('search', '')); ?>" class="form-control">
                                    </div>
                                    <div class="col-md-3 form-group">
                                        <label for="sts">Status:</label>
                                        <select class="form-control" name="sts" id="sts">
                                            <?php echo generateBlogPostStatusDropDown(request('sts', '')); ?>

                                        </select>
                                    </div>
                                </div>
                                <table class="table table-striped table-bordered" style="width: 100%"
                                    id="blogDatatableAjax">
                                    <thead>
                                        <tr>
                                            <th>Date</th>
                                            <th>Image</th>
                                            <th>Title</th>
                                            <th>Category</th>
                                            <th>Comments</th>
                                            <th>Preview</th>
                                            <th>Is Featured?</th>
                                            <th>Status</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    </tbody>
                                </table>
                            </form>
                        </div>
                        <!-- /. card-body -->
                    </div>
                    <!-- /.box -->
                    <!-- /.box -->
                </div>
            </div>
        </section>
        <!-- /.content -->
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('beforeBodyClose'); ?>
    <script>
        $(function() {
            var oTable = $('#blogDatatableAjax').DataTable({
                "autoWidth": true,
                processing: true,
                serverSide: true,
                stateSave: true,
                searching: false,
                "order": [
                    [0, "desc"]
                ],
                paging: true,
                info: true,
                ajax: {
                    url: '<?php echo route('fetchBlogPostsAjax'); ?>',
                    data: function(d) {
                        d.search = $('#search').val();
                        d.sts = $('#sts').val();
                    }
                },
                "drawCallback": function(settings) {
                    setToggles();
                },
                columns: [{
                        data: 'dated',
                        name: 'dated'
                    },
                    {
                        data: 'featured_img',
                        name: 'featured_img'
                    },
                    {
                        data: 'title',
                        name: 'title'
                    },
                    {
                        data: 'cate_ids',
                        name: 'cate_ids'
                    },
                    {
                        data: 'total_unrevised_comments',
                        name: 'total_unrevised_comments'
                    },
                    {
                        data: 'preview',
                        name: 'preview'
                    },
                    {
                        data: 'is_featured',
                        name: 'is_featured'
                    },
                    {
                        data: 'sts',
                        name: 'sts'
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    }
                ]
            });

            $('#blog-search-form').on('submit', function(e) {
                oTable.draw();
                e.preventDefault();
            });
            $('#search').on('keyup', function(e) {
                oTable.draw();
                e.preventDefault();
            });
            $('#sts').on('change', function(e) {
                oTable.draw();
                e.preventDefault();
            });
        });

        function showFilters() {
            $('#filterForm').show('slow');
            $('#showFilterbtn btn-sm').hide('slow');
            $('#hideFilterbtn btn-sm').show('slow');
        }

        function hideFilters() {
            $('#filterForm').hide('slow');
            $('#showFilterbtn btn-sm').show('slow');
            $('#hideFilterbtn btn-sm').hide('slow');
        }

        function deleteBlogPost(id) {
            var msg = 'Are you sure?';
            var url = '<?php echo e(url('adminmedia/blog-post/')); ?>/' + id;
            if (confirm(msg)) {
                $.post(url, {
                        id: id,
                        _method: 'DELETE',
                        _token: '<?php echo e(csrf_token()); ?>'
                    })
                    .done(function(response) {
                        if (response.includes('ok')) {
                            var table = $('#blogDatatableAjax').DataTable();
                            table.row('blogPostDtRow' + id).remove().draw(false);
                            Toast.fire({
                                icon: "success",
                                title: "Blog Post Deleted Successfully"
                            });
                        } else {
                            alert('Request Failed!');
                        }
                    });
            }
        }

        function updateBlogPostIsFeatured(id) {
            var old_is_featured = 1;
            var new_is_featured = 0;
            if ($('#is_featured_' + id).val() == 0) {
                old_is_featured = 0;
                new_is_featured = 1;
            }
            var url = base_url + 'adminmedia/updateBlogPostIsFeatured';
            $.post(url, {
                    id: id,
                    is_featured: new_is_featured,
                    _token: '<?php echo e(csrf_token()); ?>'
                })
                .done(function(sts) {
                    if (sts == 'Done Successfully!') {
                        $('#is_featured_' + id).val(new_is_featured);
                        alertme('<i class="fas fa-check" aria-hidden="true"></i> ' + sts, 'success', true, 1500);
                    } else {
                        $('#is_featured_' + id).val(old_is_featured);
                        if (old_is_featured == 0) {
                            $('#is_featured_' + id).bootstrapToggle('off', true)
                        } else {
                            $('#is_featured_' + id).bootstrapToggle('on', true)
                        }
                        alertme('<i class="fas fa-check" aria-hidden="true"></i> ' + sts, 'danger', true, 1500);
                    }
                });

        }
        
        function updateBlogPostStatus(id) {
            var old_sts = 1;
            var new_sts = 0;
            if ($('#sts_' + id).val() == 0) {
                old_sts = 0;
                new_sts = 1;
            }
            var url = base_url + 'adminmedia/updateBlogPostStatus';
            $.post(url, {
                    id: id,
                    sts: new_sts,
                    _token: '<?php echo e(csrf_token()); ?>'
                })
                .done(function(sts) {
                    if (sts == 'Done Successfully!') {
                        $('#sts_' + id).val(new_sts);
                        alertme('<i class="fas fa-check" aria-hidden="true"></i> ' + sts, 'success', true, 1500);
                    } else {
                        $('#sts_' + id).val(old_sts);
                        if (old_sts == 0) {
                            $('#sts_' + id).bootstrapToggle('off', true)
                        } else {
                            $('#sts_' + id).bootstrapToggle('on', true)
                        }
                        alertme('<i class="fas fa-check" aria-hidden="true"></i> ' + sts, 'danger', true, 1500);
                    }
                });

        }

        function setToggles() {
            $('input[data-toggle="toggle_is_featured"]').bootstrapToggle();
            $('input[data-toggle="toggle_sts"]').bootstrapToggle();
        }
        $(document).on('change', 'input[data-toggle="toggle_is_featured"]', function() {
            let id = $(this).attr('data-id');
            updateBlogPostIsFeatured(id);
        });
        $(document).on('change', 'input[data-toggle="toggle_sts"]', function() {
            let id = $(this).attr('data-id');
            updateBlogPostStatus(id);
        });
    </script>
    <!-- Filer -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('back.layouts.app', ['title' => $title], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/surfacest2025/site_files/resources/views/back/blog/index.blade.php ENDPATH**/ ?>