<?php $__env->startSection('content'); ?>
    <div class="content-wrapper pl-3 pr-2">
        <section class="content-header">
            <div class="row">
                <div class="col-md-5 col-sm-12">
                    <ol class="breadcrumb">
                        <li><a href="<?php echo e(base_url() . 'adminmedia'); ?>"><i class="fas fa-tachometer-alt"></i> Home</a></li>
                        <li class="active">Admin Users Log</li>
                    </ol>
                </div>
                <div class="col-md-7 col-sm-12">
                    <?php echo $__env->make('back.common_views.quicklinks', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </div>
        </section>
        <section class="content">
            <div class="row">
                <div class="col-xs-12 col-md-12">
                    <div class="card p-2">
                        <div class="row">
                            <div class="col-sm-8">
                                <div class="box-header">
                                    <h3 class=" card-title">All Admin Users Logs</h3>
                                </div>
                            </div>
                            <div class="col-sm-4">
                                <div class="text-end" style="padding-bottom:2px;">
                                    <a type="button" class="sitebtn" href="javascript:;" onClick="empty_admin_log()">Empty
                                        Log</a></div>
                            </div>
                        </div>
                        <div class=" card-body table-responsive">
                            <table id="example2" class="table table-bordered table-hover">
                                <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Admin Name</th>
                                    <th>Session Start Date/Time</th>
                                    <th>Session End Date/Time</th>
                                    
                                    <th>IP Address</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php if($usersData): ?>
                                    <?php $i = 1; ?>
                                    <?php $__currentLoopData = $usersData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr id="row_<?php echo e($row->id); ?>">
                                            <td><?php echo e($i++); ?></td>
                                            <td><?php echo e($row->user->name ?? '-'); ?></td>
                                            <td><?php echo e(format_date($row->session_start,'date_time')); ?></td>
                                            <td>
                                                <?php if($row->session_end == NULL): ?>
                                                    <?php echo e("Did not logout"); ?>

                                                <?php else: ?>
                                                    <?php echo e(format_date($row->session_end,'date_time')); ?>

                                                <?php endif; ?>
                                            </td>
                                            <td><?php echo e($row->ip_address); ?>

                                                <a target="_blank"
                                                   href="http://whois.domaintools.com/<?php echo e($row->ip_address); ?>">
                                                    <span title="<?php echo e($row->ip_address); ?>"
                                                          class="label label-success label-circled">IP</span>
                                                </a>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                    <tr>
                                        <td colspan="7">No record found!</td>
                                    </tr>
                                <?php endif; ?>
                                </tbody>
                                <tfoot>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <div>
                <?php echo e($usersData->links()); ?>

            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('beforeBodyClose'); ?>
    <script>
        function empty_admin_log() {
            if (confirm('Are you sure delete this data?')) {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    url: "<?php echo e(base_url()); ?>adminmedia/user/admin_log/0",
                    type: "DELETE",
                    success: function (data) {
                        location.reload();
                    },
                    error: function (jqXHR, textStatus, errorThrown) {
                        alert('Error adding / update data ' + ' ' + textStatus + ' ' + errorThrown);
                        console.log(jqXHR);
                        console.log(textStatus);
                        console.log(errorThrown);
                    }
                });
            }
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('back.layouts.app',['title' => $title ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/surfacest2025/site_files/resources/views/back/users/admin/admin_users_log.blade.php ENDPATH**/ ?>