<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e(config('app.name', 'Laravel')); ?></title>

    <!-- Google Font: Source Sans Pro -->
    <link rel="stylesheet"
        href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
    <link href="<?php echo e(asset_storage('back/jquery-ui/jquery-ui.min.css')); ?>" rel="stylesheet" type="text/css" />
    <!-- Font Awesome -->
    <link href="<?php echo e(asset_storage('fontawesome/css/all.min.css')); ?>" rel="stylesheet" type="text/css" />
    <!-- icheck bootstrap -->
    <link rel="stylesheet" href="<?php echo e(asset_storage('back/icheck-bootstrap/icheck-bootstrap.min.css')); ?>">
    <!-- Theme style -->
    <link href="<?php echo e(asset_storage('back/js/AdminLTE/dist/css/adminlte.min.css')); ?>" rel="stylesheet" type="text/css" />
    <link rel="icon" type="image/x-icon" href="<?php echo e(asset_uploads('admin_logo_favicon/'.config('admin_logo_favicon.admin_favicon'))); ?>">
</head>

<body class="hold-transition login-page">
    <div class="login-box">
        <div class="login-logo">
            <a href="<?php echo e(url('adminmedia')); ?>"><img src="<?php echo asset_uploads('admin_logo_favicon/'.config('admin_logo_favicon.admin_login_page_logo')); ?>" /></a>
        </div>
        <!-- /.login-logo -->
        <?php echo $__env->yieldContent('content'); ?>
        <div class="text-center m-3">Powered By <a title="MediaLinkers" href="http://www.medialinkers.com" target="_blank"><img
            src="<?php echo e(asset_storage('') . 'back/images/ml-icon.png'); ?>" /></a></div>
    </div>
    <!-- /.login-box -->

    <script src="<?php echo e(asset_storage('back/js/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset_storage('back/jquery-ui/jquery-ui.min.js')); ?>"></script>
    <script src="<?php echo e(asset_storage('back/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>
    <script src="<?php echo e(asset_storage('back/js/AdminLTE/dist/js/adminlte.min.js')); ?>"></script>
    <?php echo $__env->yieldContent('beforeBodyClose'); ?>
</body>

</html>
<?php /**PATH /home/native33/public_html/client/surfacestatement/resources/views/layouts/backend/guest.blade.php ENDPATH**/ ?>