
<?php $__env->startSection('content'); ?>
    <div class="content-wrapper pl-3 pr-2">
        <section class="content-header">
            <div class="row">
                <div class="col-md-5 col-sm-12">
                    <ol class="breadcrumb">
                        <li><a href="<?php echo e(admin_url()); ?>"><i class="fas fa-tachometer-alt"></i> Home</a></li>
                        <li class="active">Manage Admin Users</li>
                    </ol>
                </div>
                <div class="col-md-7 col-sm-12">
                    <?php echo $__env->make('back.common_views.quicklinks', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </div>
        </section>
        <section class="content">
            <div class="row">
                <div class="col-xs-12 col-md-12">
                    <div class="card p-2">
                        <div class="row">
                            <div class="col-sm-8">
                                <div class="box-header">
                                    <h3 class=" card-title">Admin Users</h3>
                                    <div class="clearfix"></div>
                                    <br>
                                    <a class="btn btn-primary" href="<?php echo e(route('admin.show', 0)); ?>">User Access Controle List</a>
                                </div>
                            </div>
                            <div class="col-sm-4">
                                <div class="text-end" style="padding-bottom:2px;">
                                    <?php if(Auth::user()->type == config('Constants.USER_TYPE_SUPER_ADMIN')): ?>
                                        <a type="button" class="sitebtn" href="<?php echo e(route('admin.create')); ?>">Add
                                            New Admin User</a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <div class=" card-body table-responsive">
                            <table id="example2" class="table table-bordered table-hover">
                                <thead>
                                    <tr>
                                        <th>Created Date</th>
                                        <th>Name</th>
                                        <th>Email</th>
                                        <?php if(Auth::user()->type == config('Constants.USER_TYPE_SUPER_ADMIN')): ?>
                                            <th>Type</th>
                                            <th>Action</th>
                                        <?php endif; ?>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if($result): ?>
                                        <?php $__currentLoopData = $result; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr id="row_<?php echo e($row->id); ?>">
                                                <td><?php echo e(format_date($row->created_at, 'date')); ?></td>
                                                <td><?php echo e($row->name); ?></td>
                                                <td><?php echo e($row->email); ?></td>
                                                <?php if(Auth::user()->type == config('Constants.USER_TYPE_SUPER_ADMIN')): ?>
                                                    <td>
                                                        <?php if($row->type == config('Constants.USER_TYPE_SUPER_ADMIN')): ?>
                                                            Super Admin
                                                        <?php endif; ?>

                                                        <?php if($row->type == config('Constants.USER_TYPE_NORMAL_ADMIN')): ?>
                                                            Normal Admin
                                                        <?php endif; ?>

                                                        <?php if($row->type == config('Constants.USER_TYPE_REPS_ADMIN')): ?>
                                                            Reps
                                                        <?php endif; ?>
                                                    </td>
                                                    <td>
                                                        <a href="<?php echo e(route('admin.edit', $row->id)); ?>"
                                                            class="btn btn-success btn-sm">Edit</a>
                                                        <a href="javascript:;"
                                                            onClick="delete_admin_user(<?php echo e($row->id); ?>)"
                                                            class="btn btn-info btn-sm btn-danger">Delete User</a>
                                                    </td>
                                                <?php endif; ?>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                        <tr>
                                            <td colspan="8">No record found!</td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                                <tfoot>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('beforeBodyClose'); ?>
    <script>
        function delete_admin_user(id) {
            $('.message-container').fadeOut(3000);
            if (confirm('Are you sure delete this data?')) {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    url: "<?php echo e(admin_url() . 'user/admin/'); ?>" + id,
                    type: "DELETE",
                    success: function(data) {
                        //if success reload ajax table
                        $('#modal_form').modal('hide');
                        location.reload();
                    },
                    error: function(jqXHR, textStatus, errorThrown) {
                        alert('Error adding / update data ' + ' ' + textStatus + ' ' + errorThrown);
                    }
                });
            }
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('back.layouts.app', ['title' => $title], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/surfacest2025/site_files/resources/views/back/users/admin/index.blade.php ENDPATH**/ ?>