jQuery(function(){
	initStickyHeader();
	initGoTop();
	initBurgerMenu();
});

// Sticky header
function initStickyHeader(){
	var idName = '#header';
	var className ='sticky';
	jQuery(document).on('scroll', function(){
	  if(jQuery(this).scrollTop() > 1){
		jQuery(idName).addClass(className); 
	  }
	  else{
		jQuery(idName).removeClass(className);
	  }
	});
}

  document.getElementById('searchToggle').addEventListener('click', function (e) {
    e.preventDefault(); // Prevents page jump
    var field = document.getElementById('searchField');
    var icon = this;

    // Toggle field visibility
    if (field.style.display === 'none' || field.style.display === '') {
      field.style.display = 'block';
      icon.classList.add('active');
    } else {
      field.style.display = 'none';
      icon.classList.remove('active');
    }
  });

  
// Back to top
function initGoTop(){
	var selector        = '.go-top';
	var activeClassName = 'active';
	jQuery(document).on('scroll', function(){
		if(jQuery(this).scrollTop() > 400){
			jQuery(selector).addClass(activeClassName);	
		}
		else{
			jQuery(selector).removeClass(activeClassName);
		}
	});
}

// Burger Menu
function initBurgerMenu(){
    jQuery('.navbar .navbar-toggler').click(function() {
		jQuery('body').toggleClass('nav-active');
	});
}

   
  function toggleFilter() {
    const filter = document.getElementById('filtercol');
    const product = document.getElementById('productcol');

    if (filter.classList.contains('d-none')) {
      // Show filter
      filter.classList.remove('d-none');
      filter.style.width = '30%';
      product.style.width = '70%';
    } else {
      // Hide filter
      filter.classList.add('d-none');
      filter.style.width = '0';
      product.style.width = '100%';
    }
  }
 

  function toggleFilter() {
    const filter = document.getElementById('filtercol');
    const product = document.getElementById('productcol');

    filter.classList.toggle('active');
    product.classList.toggle('shrink');
  }

 /* ================ Sortable Masonary with Filters ================ */
    function enableMasonry() {
        if ($('.sortable-masonry').length) {
            var winDow = $(window);
            // Needed variables
            var $container = $('.sortable-masonry .items-container');
            var $filter = $('.filter-btns');
            $container.isotope({
                filter: '*',
                masonry: {
                    columnWidth: 0
                },
                animationOptions: {
                    duration: 1000,
                    easing: 'linear'
                }
            });

            /* ================ Isotope Filter ================ */
            $filter.find('li').on('click', function() {
                var selector = $(this).attr('data-filter');

                try {
                    $container.isotope({
                        filter: selector,
                        animationOptions: {
                            duration: 1000,
                            easing: 'linear',
                            queue: false
                        }
                    });
                } catch (err) {

                }
                return false;
            });

            winDow.bind('resize', function() {
                var selector = $filter.find('li.active').attr('data-filter');
                $container.isotope({
                    filter: selector,
                    animationOptions: {
                        duration: 1000,
                        easing: 'linear',
                        queue: false
                    }
                });
            });

            var filterItemA = $('.filter-btns li');
            filterItemA.on('click', function() {
                var $this = $(this);
                if (!$this.hasClass('active')) {
                    filterItemA.removeClass('active');
                    $this.addClass('active');
                }
            });
        }
    }



    

$(document).ready(function() { 
        $('.fancybox').fancybox(); 
        // Change title type, overlay closing speed
        $(".fancybox-effects-a").fancybox({
            autoPlay    : false,
            helpers: {
                title : {
                    type : 'outside'
                },
                overlay : {
                    speedOut : 0
                }
            }
        });
         
    });
 


    enableMasonry();