@extends('front.layout.app')
@section('content')
    <?php $settingInformation = settingArr(); ?>

    <script src='https://www.google.com/recaptcha/api.js'></script>
    <style>
        .error-bg {
            background-color: #e6cfcf;
        }

        .error {
            color: #FF0000;
        }
    </style>
    <!-- Start Banner
        ============================================= -->
    <main id="main">
       

        <!--Collection Start-->


        <!-- End Banner -->



 <div class="collectimg"><img src="{{ asset_storage('front/images/testata_pagina_snodo_brand_ergon.jpg') }}" alt="">
<h1>{{$result->heading}} collections</h1>
 </div>

<div class="collection-gallery">
<div class="container">




<div class="row">
    
   @forelse ($get_all_product_visuals as $product)
<!--Default Portfolio Item--> 
<div class="col-lg-3 col-md-4 col-sm-6 col-xs-12">
            <div class="colorchoice default-collect-item">
            	<div class="image-box mb-3">
  <div class="flip-container">
    <img class="front-img" src="{{ asset_uploads('products/' . $product->product_img) }}" alt="{{ $product->product_img_alt ?: $product->product_name }}" title="{{ $product->product_img_title ?: $product->product_name }}">
    <img class="back-img" src="{{ asset('uploads/products/'.$product->product_color_image) }}" alt="">
  </div>

  <div class="surface-logo">
    <img src="{{ asset('uploads/products/'.$product->brand_logo_image) }}" alt="">
  </div>
</div>
<h4><a href="{{ route('products.show', $product->product_slug) }}">{{ $product->product_name }}</a></h4>
           
</div>
</div>
 @empty
                                <div class="col-12">
                                    <p>No products found.</p>
                                </div>
@endforelse
    

</div>



<!--<div class="blog-pagination text-center"> <a href="#0"><i class="fas fa-angle-left"></i></a> <a href="#0">01</a> <a href="#0" class="active">02</a> <a href="#0">03</a> <a href="#0"><i class="fas fa-angle-right"></i></a> </div>-->



</div>
</div>






        {{-- Contact --}}
        <div class="call-us-area collect_call" id="contact">
            <div class="container">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="call-now m-0">
                            <div class="text">
                                <h3>Contact Us</h3>
                                <p>Let's start a conversation. <a title="Contact Us"
                                        href="https://surfacestatement.nativeathletics.com/contact-us" target="_blank"
                                        rel="noopener">Email Us!</a></p>
                            </div>

                            <div class="hmctinfo">
                                <div class="info">
                                    <div class="icon">
                                        <i class="fa-solid fa-phone"></i>
                                    </div>
                                    <div class="frame">
                                        <span class="call-today">Call Us Today</span>
                                        <a href="tel:@php echo FindInsettingArr('telephone'); @endphp"
                                            class="tel">@php echo FindInsettingArr('telephone'); @endphp</a>
                                    </div>
                                </div>
                                <div class="info">
                                    <div class="icon">
                                        <i class="fa-solid fa-envelope"></i>
                                    </div>
                                    <div class="frame">
                                        <span class="call-today">Mail Us Today</span>
                                        <a href="mailto:@php echo FindInsettingArr('email'); @endphp"
                                            class="tel">@php echo FindInsettingArr('email'); @endphp</a>
                                    </div>
                                </div>
                            </div>


                        </div>
                    </div>
                </div>
            </div>
        </div>




        <!-- Modal -->
        <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">Ask Any Question</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="productForm popform">
                            <form method="POST" action="" id="contactForm">
                                @csrf
                                <div class="row">
                                    <div class="col-lg-6 col-md-6">
                                        <div class="input-group">
                                            <input type="text" name="name" class="form-control" placeholder="Name"
                                                pattern="[A-Za-z\s]+" title="Only alphabets and spaces are allowed"
                                                onkeypress="return /^[a-zA-Z\s]+$/.test(event.key)">
                                        </div>
                                        <div id="name-error" class="error"></div>
                                    </div>
                                    <div class="col-lg-6 col-md-6">
                                        <div class="input-group">
                                            <input type="email" name="email" class="form-control" placeholder="Email">
                                        </div>
                                        <div id="email-error" class="error"></div>
                                    </div>
                                    <div class="col-lg-6 col-md-6">
                                        <div class="input-group">
                                            <input type="text" name="phone" id=phone class="form-control"
                                                placeholder="Phone">
                                        </div>
                                        <div id="phone-error" class="error"></div>
                                    </div>
                                    <div class="col-lg-6 col-md-6">
                                        <div class="input-group">
                                            <input type="text" name="tile_name" class="form-control"
                                                placeholder="Tile Name">
                                        </div>
                                        <div id="tile_name-error" class="error"></div>
                                    </div>
                                    <div class="col-lg-12 col-md-12">
                                        <div class="input-group">
                                            <select class="form-control" name="category">
                                                <option value="">Select Category</option>
                                                <option value="Wall Tile">Wall Tile</option>
                                                <option value="American Made">American Made</option>
                                                <option value="Natural Stone Visuals">Natural Stone Visuals</option>
                                                <option value="Wood Visuals">Wood Visuals</option>
                                                <option value="Concrete">Concrete</option>
                                                <option value="Metallic Visuals">Metallic Visuals</option>
                                                <option value="Color Visuals">Color Visuals</option>
                                                <option value="All lines">All lines</option>
                                            </select>
                                        </div>
                                        <div id="category-error" class="error"></div>
                                    </div>
                                    <div class="col-lg-12">
                                        <div class="input-group">
                                            <textarea class="form-control" name="message" placeholder="Message"></textarea>
                                        </div>
                                    </div>
                                    <div class="col-lg-12">
                                        <div class="g-recaptcha" data-sitekey="{{ $siteKey }}"></div>
                                    </div>
                                    <div class="col-lg-12 mt-3">
                                        <div class="input-group d-block m-0 text-center">
                                            <button type="button" onclick="submitContactFormAjax();"
                                                class="submit-btn"><span>Submit Now</span></button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </main>
@endsection
@section('beforeBodyClose')
    <script src="{{ asset_storage('lib/sweetalert2.js') }}"></script>
    <script>
        (function() {
            document.addEventListener('click', function(e) {
                var target = e.target.closest('.filter-tabs .filter');
                if (!target) return;
                e.preventDefault();
                var filter = target.getAttribute('data-filter');
                document.querySelectorAll('.filter-tabs .filter').forEach(function(li) {
                    li.classList.remove('active');
                });
                target.classList.add('active');
                var items = document.querySelectorAll('.masonry-item');
                if (filter === '*' || filter === '.all') {
                    items.forEach(function(el) {
                        el.style.display = '';
                    });
                } else {
                    items.forEach(function(el) {
                        el.style.display = 'none';
                    });
                    document.querySelectorAll('.masonry-item' + filter).forEach(function(el) {
                        el.style.display = '';
                    });
                }
            });
        })();
    </script>
    <script>
        $('#search-box').on('keyup', function() {
            let query = $(this).val();
            if (query.length > 1) {
                $.ajax({
                    url: '{{ route('products.suggest') }}',
                    data: {
                        query: query
                    },
                    success: function(data) {
                        let suggestions = '';
                        data.forEach(function(item) {
                            suggestions += '<div class="suggestion-item">' + item + '</div>';
                        });
                        $('#suggestions').html(suggestions).show();
                    }
                });
            } else {
                $('#suggestions').hide();
            }
        });

        // Optional: Click on suggestion to fill input
        $(document).on('click', '.suggestion-item', function() {
            $('#search-box').val($(this).text());
            $('#suggestions').hide();
        });
    </script>


    <script>
        function submitContactFormAjax() {

            url = "{{ route('ask-a-queston-save') }}";
            method = 'POST';
            header = '';
            let formData = new FormData($('#contactForm')[0]);

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: url,
                type: method,
                data: formData,
                headers: header,
                async: true,
                cache: false,
                contentType: false,
                processData: false,
                success: function(data) {
                    //data = JSON.parse(data);
                    //console.log(data.error);
                    if (data.status) {
                        $("#contactForm").trigger('reset');
                        Swal.fire({
                            title: 'Thank you!',
                            html: 'Your message has been sent.',
                            timer: 2000,
                            timerProgressBar: false
                        })
                    } else {
                        swal(

                            'Sorry!',
                            data.error,
                            'error'

                        );
                    }
                },
                error: function(data) {
                    if (data.status === 422) {
                        var responseText = $.parseJSON(data.responseText);
                        $.each(responseText.errors, function(key, value) {
                            $('#' + key + '-error').html(value);
                            $('#' + key + '-error').addClass('formValidationErrors');
                            $('#' + key + '-error').show();
                            scrollToErrors('.formValidationErrors');
                        });
                    }
                }
            });
        }
    </script>
    <script>
        function formatPhoneNumber(value) {
            // Remove non-numeric characters
            value = value.replace(/\D/g, '');

            // Add space after every 3 digits
            if (value.length > 6) {
                value = value.substring(0, 3) + ' ' + value.substring(3, 6) + ' ' + value.substring(6, 10);
            } else if (value.length > 3) {
                value = value.substring(0, 3) + ' ' + value.substring(3);
            }

            return value;
        }

        document.addEventListener('DOMContentLoaded', function() {
            const phoneInput = document.getElementById('phone');

            phoneInput.addEventListener('input', function() {
                this.value = formatPhoneNumber(this.value);
            });
        });
    </script>
@endsection
