@extends('front.layout.app')

@section('content')


		<section class="breadcrumb-section singlewrap">
        <div class="container-auto">
            <div class="row">
                <div class="col-md-6 col-sm-6 col-12">
                    <div class="page-title">
                        <h1>{{ $product->product_name }}
</h1>
                    </div>
                </div>
                <div class="col-md-6 col-sm-6 col-12">
                    <nav aria-label="breadcrumb" class="theme-breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="index.html">Home</a></li> 
                            <li class="breadcrumb-item active" aria-current="page">{{ $product->product_name }}
</li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
    </section>

<main id="main" > 

	<div class="container-fluid">
<div class="row align-items-center">
<div class="col-lg-4">
		<div class="product-info">
{!! $product->slider_description !!}
	<div class="surface-logo2"><img src="{{ asset_storage('front/images/surface-logo.png')}}" alt="Surface Statement"></div>
</div>
</div>
<div class="col-lg-8">
    <div id="carouselExampleIndicators" class="carousel slide">
        
        {{-- Dynamic Indicators --}}
        <div class="carousel-indicators">
            @foreach ($productSliderImages as $key => $images)
                <button type="button" 
                        data-bs-target="#carouselExampleIndicators" 
                        data-bs-slide-to="{{ $key }}" 
                        class="{{ $key == 0 ? 'active' : '' }}" 
                        aria-current="{{ $key == 0 ? 'true' : 'false' }}" 
                        aria-label="Slide {{ $key + 1 }}">
                </button>
            @endforeach
        </div>

        {{-- Dynamic Slides --}}
        <div class="carousel-inner">
            @foreach ($productSliderImages as $key => $images)
                <div class="carousel-item {{ $key == 0 ? 'active' : '' }}">
                    <img src="{{ asset_uploads($images->image_name) }}" class="d-block w-100" alt="Slide {{ $key + 1 }}">
                </div>
            @endforeach
        </div>

        {{-- Controls --}}
        <button class="carousel-control-prev" type="button" data-bs-target="#carouselExampleIndicators" data-bs-slide="prev">
            <span class="carousel-control-prev-icon" aria-hidden="true"></span>
            <span class="visually-hidden">Previous</span>
        </button>
        <button class="carousel-control-next" type="button" data-bs-target="#carouselExampleIndicators" data-bs-slide="next">
            <span class="carousel-control-next-icon" aria-hidden="true"></span>
            <span class="visually-hidden">Next</span>
        </button>

    </div>
</div>

</div>

</div>
</div>



{!! $product->product_description !!}


	

		<!--Collection Start-->
			 <div class="pagecontent collect-details pt-0" id="colorsize">


 
 
  <div class="container">





<div class="container mt-5" id="download">
	<h2>Sizes and colours</h2>
	<div class="item-del"> 
							{!! $product->sizes_colors !!}
							</div>

<div class="colorchoice mt4 
        @if (request()->is('collections/glassa')) glassa_wraper @endif 
        @if (request()->is('collections/tonal')) tonal_wraper @endif ">
    <div class="row">
        @foreach ($get_all_product_colors as $color)
            <div class="col-lg-2 col-md-3 col-6 default-collect-item">
                <div class="fondo-img mb-3">
                    <img src="{{ asset_uploads('module/product-colors/' . $color->featured_img) }}" alt="">
                </div>
                <h4><a href="{{ route('product.single.color', [
    'product' => $product->product_slug,
    'color'   => str_replace('product-colors/', '', $color->post_slug)
]) }}">
    {{ $color->heading }}
</a>
</h4>
            </div>
        @endforeach
    </div>
</div>

<div class="row">
<div class="col-lg-6">
@php
    $pdfPath = $product->product_pdf 
        ? public_path('uploads/products/pdf/' . $product->product_pdf) 
        : null;
@endphp

<div class="colorWrp download_sec" id="contact">
    <h4 class="mb-3">Download PDF</h4>  
    <div class="downimg mb-3">
        <img src="https://surfacestatement.nativeathletics.com/mlstorage/front/images/download-arrow.png" alt="">
    </div>

    <div class="cartflex">
        @if($pdfPath && file_exists($pdfPath))
            <div class="btn-holder btn_catalog">
                <a href="{{ asset('uploads/products/pdf/' . $product->product_pdf) }}" 
                   class="btn-orange" 
                   target="_blank" 
                   download>
                   Download PDF
                </a>
            </div>
        @else
            <span class="text-muted">No PDF available</span>
        @endif
    </div>
</div>

</div>


<div class="col-lg-6">
<div class="colorWrp download_sec" id="contact">
<h4 class="mb-3">Add to Cart</h4>  
 <div class="downimg mb-3"><img src="https://surfacestatement.nativeathletics.com/mlstorage/front/images/baskat.png" alt=""></div>
 
 <div class="cartflex">
 <form action="{{ route('cart.add', $product->id) }}" method="POST">
    @csrf
    <button type="submit" class="btn btn-primary">
        Add to Cart
    </button>
</form>
</div> 
 </div> 

</div>
</div>
 
</div> 


 </div>
 
                        
 



<div class="call-us-area collect_call">
            <div class="container">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="call-now">
                            <div class="text">
                                <h3>Contact Us</h3>
                                <p>Let's start a conversation. <a title="Contact Us" href="https://www.surfacestatement.directfinding.com/contact-us" target="_blank" rel="noopener">Email Us!</a></p>
                            </div>
                            
                            <div class="hmctinfo">
                            <div class="info">
                                <div class="icon">
                                    <i class="fa-solid fa-phone"></i>
                                </div>
                                <div class="frame">
                                    <span class="call-today">Call Us Today</span>
                                    <a href="tel:4049903232" class="tel">404-990-3232</a>
                                </div>
                            </div>
                            <div class="info">
                                <div class="icon">
                                    <i class="fa-solid fa-envelope"></i>
                                </div>
                                <div class="frame">
                                    <span class="call-today">Mail Us Today</span>
                                    <a href="mailto:info@surfacestatement.com" class="tel">info@surfacestatement.com</a>
                                </div>
                            </div>
                            </div>
                            
                            
                        </div>
                    </div>
                </div>
            </div>
        </div>

 </div>



  </div>
  

<div class="btn-holder btn_catalog fixbtn">
    <form action="{{ route('cart.add', $product->id) }}" method="POST" class="quick-ship-form">
        @csrf
        <a href="#" class="btn-orange quick-ship-link">Quick Ship</a>
    </form>
</div>
			 
			 
		</main>
		
	

@endsection
@section('beforeBodyClose')

<script>
document.addEventListener('DOMContentLoaded', function() {
    document.querySelectorAll('.quick-ship-link').forEach(link => {
        link.addEventListener('click', function(e) {
            e.preventDefault();
            this.closest('form').submit();
        });
    });
});
</script>
	<script>
		/* ================ Close Sidebar ================ */
    $('.fa-angle-down').on("click", function(e) {
        e.preventDefault();
        $(this).next().slideToggle('');
    });
    /* ================ Nav ================ */
$('[data-toggle="offcanvas"]').on('click', function () {
    $('.navbar-collapse').toggleClass('show');
    });
	</script>

<script>
  function toggleText() {
    const text = document.getElementById("textBlock");
    const btn = document.getElementById("toggleBtn");

    text.classList.toggle("expanded");

    if (text.classList.contains("expanded")) {
      btn.textContent = "Show Less";
    } else {
      btn.textContent = "View More";
    }
  }
</script>

@endsection