@extends('front.layout.app')
@section('beforeHeadClose')
    <link href="{{ asset_storage('') . 'module/blog/front/css/blog.css' }}" rel="stylesheet" type="text/css" />
    <script src='https://www.google.com/recaptcha/api.js'></script>
    <style>
        .error-bg {
            background-color: #e6cfcf;
        }

        .error {
            color: #FF0000;
        }
    </style>
@endsection
@section('content')

		<section class="breadcrumb-section">
        <div class="container-auto">
            <div class="row">
                <div class="col-md-6 col-sm-6 col-12">
                    <div class="page-title">
                        <h1> Cart</h1>
                    </div>
                </div>
                <div class="col-md-6 col-sm-6 col-12">
                    <nav aria-label="breadcrumb" class="theme-breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="index.html">Home</a></li>
                            <!--<li class="breadcrumb-item"><a href="index.html">Cart</a></li>-->
                            <li class="breadcrumb-item active" aria-current="page"> Cart</li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
    </section>
		 
<main id="main"> 


		<!--Collection Start-->
			 <div class="pagecontent collect-details ">
 
 
  <div class="container">
<h2 class="text-center">Sample Basket</h2> 
<div class="productForm"> 
	<form action="" method="POST" class="form--contact" id="contactorderForm"> 
				@csrf

     <div class="table_desc">
       <div class="table_page table-responsive">
          <table>
             <thead>
                <tr>
                   <th class="product_remove">Delete</th>
                   <th class="product_thumb">Image</th>
                   <th class="product_name">Product</th>
                   <th class="product-price">Category</th>
                </tr>
             </thead>
             <tbody>
                @foreach($cart as $id => $item)
                    <tr>
                        <td class="product_remove">
                            <button type="button" class="btn btn-link p-0 text-danger delete-btn" 
                                    data-id="{{ $id }}">
                                <i class="fas fa-trash-alt"></i>
                            </button>
                        </td>
                        <td class="product_thumb">
                            @if($item['image'])
                               <a href="#"><img src="{{ asset_uploads('products/'.$item['image']) }}" width="80" alt=""></a>
                            @else
                               <span>No Image</span>
                            @endif
                        </td>
                        <td class="product_name">
                            {{ $item['name'] }}
                            <input type="hidden" name="products[{{ $id }}][name]" value="{{ $item['name'] }}">
                        </td>
                        <td class="product-category">
                            {{ $item['category'] ?? 'N/A' }}
                            <input type="hidden" name="products[{{ $id }}][category]" value="{{ $item['category'] ?? '' }}">
                        </td>
                    </tr>
                @endforeach
             </tbody>
          </table>
       </div> 
    </div>

     <!-- Order Form Fields -->
     <ul class="nav nav-tabs mt-4" id="myTab" role="tablist">
        <li class="nav-item" role="presentation">
          <span class="nav-link active disabled">Order Form</span>
        </li>
     </ul>

     <div class="tab-content">
       <div class="tab-pane fade show active">
         <div class="row cartformpage">
           <div class="col-lg-4 col-md-4">
             <input type="text" name="name" class="form-control" placeholder="Name" pattern="[A-Za-z\s]+" title="Only alphabets and spaces are allowed"
                                    onkeypress="return /^[a-zA-Z\s]+$/.test(event.key)">
             <div id="name-error" class="error"></div>
           </div>
           <div class="col-lg-4 col-md-4">
             <input type="email" name="email" class="form-control" placeholder="Email" required>
             <div id="email-error" class="error"></div>
           </div>
           <div class="col-lg-4 col-md-4">
             <input type="text" name="phone" id="phone" class="form-control" placeholder="Phone" required>
             <div id="phone-error" class="error"></div>
           </div>
           <div class="col-lg-12">
             <textarea name="message" class="form-control" placeholder="Message"></textarea>
           </div>
           
           <div class="col-lg-12">
           <div class="g-recaptcha" data-sitekey="{{ $siteKey }}"></div>
							<div id="g-recaptcha-response-error" class="error">
							    
							</div>
				</div>			
				
           <div class="col-lg-12 text-center">
             <button type="button" onclick="submitContactOrderFormAjax();" class="submit-btn"><span>Submit Now</span></button>
           </div>
         </div>
       </div>
     </div>
</form>

<!-- Hidden delete form -->
<form id="deleteForm" method="POST" style="display:none;">
    @csrf
    @method('DELETE')
</form>




 


<div class="call-us-area collect_call m-0" id="contact">
            <div class="container">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="call-now">
                            <div class="text">
                                <h3>Contact Us</h3>
                                <p>Let's start a conversation. <a title="Contact Us" href="https://www.surfacestatement.directfinding.com/contact-us" target="_blank" rel="noopener">Email Us!</a></p>
                            </div>
                            
                            <div class="hmctinfo">
                            <div class="info">
                                <div class="icon">
                                    <i class="fa-solid fa-phone"></i>
                                </div>
                                <div class="frame">
                                    <span class="call-today">Call Us Today</span>
                                    <a href="tel:@php echo FindInsettingArr('telephone'); @endphp" class="tel">@php echo FindInsettingArr('telephone'); @endphp</a>
                                </div>
                            </div>
                            <div class="info">
                                <div class="icon">
                                    <i class="fa-solid fa-envelope"></i>
                                </div>
                                <div class="frame">
                                    <span class="call-today">Mail Us Today</span>
                                    <a href="mailto:@php echo FindInsettingArr('email'); @endphp" class="tel">@php echo FindInsettingArr('email'); @endphp</a>
                                </div>
                            </div>
                            </div>
                            
                            
                        </div>
                    </div>
                </div>
            </div>
        </div>




				</div>
  </div>
  <!--Collection End-->
</div>			 
			 
		</main>

@endsection
@section('beforeBodyClose')
<script>

document.querySelectorAll('.delete-btn').forEach(btn => {
    btn.addEventListener('click', function () {
        let id = this.dataset.id;
        let form = document.getElementById('deleteForm');

        // Use route() with placeholder replacement
        form.action = "{{ route('cart.remove', ':id') }}".replace(':id', id);
        form.submit();
    });
});
</script>

<script src="{{ asset_storage('lib/sweetalert2.js') }}"></script>
<script>
    function submitContactOrderFormAjax() {
      
        url = "{{ route('submit.order') }}";
        method = 'POST';
        header = '';
        let formData = new FormData($('#contactorderForm')[0]);
        
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        $.ajax({
            url: url,
            type: method,
            data: formData,
            headers: header,
            async: true,
            cache: false,
            contentType: false,
            processData: false,
            success: function(data) {
                //data = JSON.parse(data);
                //console.log(data.error);
                if (data.status) {
                    $("#contactorderForm").trigger('reset');
                    Swal.fire({
                        title: 'Thank you!',
                        html: 'Your message has been sent.',
                        timer: 2000,
                        timerProgressBar: false
                    })
                    window.reload();
                } else {
                    swal(

                            'Sorry!',
                            data.error,
                            'error'

                        );
                }
            },
            error: function(data) {
                if (data.status === 422) {
                    var responseText = $.parseJSON(data.responseText);
                    $.each(responseText.errors, function(key, value) {
                        $('#' + key + '-error').html(value);
                        $('#' + key + '-error').addClass('formValidationErrors');
                        $('#' + key + '-error').show();
                        scrollToErrors('.formValidationErrors');
                    });
                }
            }
        });
    }
</script>
<script>
    function formatPhoneNumber(value) {
        // Remove non-numeric characters
        value = value.replace(/\D/g, '');

        // Add space after every 3 digits
        if (value.length > 6) {
            value = value.substring(0, 3) + ' ' + value.substring(3, 6) + ' ' + value.substring(6, 10);
        } else if (value.length > 3) {
            value = value.substring(0, 3) + ' ' + value.substring(3);
        }

        return value;
    }

    document.addEventListener('DOMContentLoaded', function() {
        const phoneInput = document.getElementById('phone');

        phoneInput.addEventListener('input', function() {
            this.value = formatPhoneNumber(this.value);
        });
    });
</script>
<script>
function addToCart(productId) {
    $.ajax({
        url: "/cart/add/" + productId,
        method: "POST",
        data: {_token: "{{ csrf_token() }}"},
        success: function(response) {
            if (response.status === "success") {
                $(".cart-count").text(response.cart_count);
            }
        }
    });
}

</script>

@endsection