@extends('front.layout.app')
@section('beforeHeadClose')
    <link href="{{ asset_storage('') . 'module/blog/front/css/blog.css' }}" rel="stylesheet" type="text/css" />
@endsection
@section('content')
    @php echo cms_edit_page("blog");@endphp
    {!! cms_page_heading('Blog') !!}
		<section class="breadcrumb-section">
        <div class="container-auto">
            <div class="row">
                <div class="col-md-6 col-sm-6 col-12">
                    <div class="page-title">
                        <h1>News</h1>
                    </div>
                </div>
                <div class="col-md-6 col-sm-6 col-12">
                    <nav aria-label="breadcrumb" class="theme-breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{ base_url() }}">Home</a></li>
                            <li class="breadcrumb-item active" aria-current="page">News</li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
    </section>
		 
<main id="main"> 


		<!--Collection Start-->
		<section class="news-2-area news-page">
        <div class="container">
            <div class="row justify-content-center">
                 @if (count($blogData) > 0)
                                @foreach ($blogData as $blogsValues)
                <div class="col-lg-4 col-md-7">
                    <div class="news-item mt-30">
                        <div class="news-thumb">
                             @if (!empty($blogsValues['featured_img']) && file_exists(storage_uploads('blog/' . $blogsValues['featured_img'])))
                            <img src="{{ asset_uploads('blog/' . $blogsValues['featured_img']) }}" title="{{ $blogsValues['featured_img_title'] }}" alt="{{ $blogsValues['featured_img_alt'] }}">
                             @else
                              <img src="{{ asset_uploads('back/images/no_image.jpg') }}"
                                                        title="{{ $blogsValues['featured_img_title'] }}"
                                                        alt="{{ $blogsValues['featured_img_alt'] }}">
                           @endif
                        </div>
                        <div class="news-content">
                            <ul>
                                <li><i class="fa-solid fa-user"></i> by admin</li>
                                <li><i class="fa-solid fa-calendar"></i>{{ date('M d, Y ', strtotime($blogsValues['dated'])) }}</li>
                            </ul>
                            <h3 class="title"><a href="{{ base_url() . 'blog/' . $blogsValues['post_slug'] }}">@php echo $blogsValues['title']; @endphp</a></h3>
                            <div class="arrow_btn"><a href="{{ base_url() . 'blog/' . $blogsValues['post_slug'] }}" class="basketicon"><i class="fa-solid fa-arrow-right"></i></a></div>
                        </div>
                    </div>
                </div>
                 
          @endforeach
                                <div class="clearfix"></div>
                            @else
                                <p style="text-align: center;">No Record Found</p>
                            @endif


                 
            </div>
        </div>
    </section>
  <!--Collection End-->
			 

 
		</main>
@endsection
