<script type="text/javascript">
    var uploadProductExtraImagesUrl = "{{ admin_url() }}uploadProductsExtraImages";
    var deleteProductExtraImageUrl = "{{ admin_url() }}removeProductExtraImage";
    var saveProductExtraImagesSortOrderUrl = "{{ admin_url() }}saveProductExtraImagesSortOrder";
    var getProductExtraImageAltTitleUrl = "{{ admin_url() }}getProductExtraImageAltTitle";
    var saveProductExtraImageAltTitleUrl = "{{ admin_url() }}saveProductExtraImageAltTitle";

    // Initialize sortable for images
    $(document).ready(function() {
        initProductExtraImagesSortable();
    });

    function initProductExtraImagesSortable() {
        $("#product_extra_images_container").sortable({
            items: ".image-item",
            handle: ".sort-handle",
            update: function(event, ui) {
                saveProductExtraImagesSortOrder();
            }
        });
    }

    function saveProductExtraImagesSortOrder() {
        var ids = [];
        $("#product_extra_images_container .image-item").each(function() {
            ids.push($(this).data('id'));
        });

        $.ajax({
            url: saveProductExtraImagesSortOrderUrl,
            type: "POST",
            data: {
                ids: ids,
                _token: $('meta[name="csrf-token"]').attr('content')
            },
            success: function(response) {
                if (response.status) {
                    showMessage('Sort order updated successfully', 'success');
                } else {
                    showMessage('Failed to update sort order', 'error');
                }
            },
            error: function() {
                showMessage('Error updating sort order', 'error');
            }
        });
    }

    function deleteProductExtraImage(imageId, fileName) {
        if (confirm('Are you sure you want to delete this image?')) {
            $.ajax({
                url: deleteProductExtraImageUrl,
                type: "POST",
                data: {
                    product_extra_image_id: imageId,
                    _token: $('meta[name="csrf-token"]').attr('content'),
                },
                success: function(response) {
                    if (response.status) {
                        $('#image-item-' + imageId).remove();
                        showMessage('Image deleted successfully', 'success');
                    } else {
                        showMessage(response.message || 'Failed to delete image', 'error');
                    }
                },
                error: function() {
                    showMessage('Error deleting image', 'error');
                }
            });
        }
    }

    function uploadProductExtraImages() {
        var formData = new FormData();
        var hasFiles = false;
        var fileInputs = [];
        
        // Handle regular slider images
        var sliderFiles = $('#product_extra_images')[0] ? $('#product_extra_images')[0].files : [];
        if (sliderFiles.length > 0) {
            for (var i = 0; i < sliderFiles.length; i++) {
                formData.append('product_extra_images[]', sliderFiles[i]);
                hasFiles = true;
            }
            fileInputs.push('#product_extra_images');
        }
        
        // Handle before/after images (first set)
        var beforeFiles = $('#product_extra_images_before')[0] ? $('#product_extra_images_before')[0].files : [];
        if (beforeFiles.length > 0) {
            for (var i = 0; i < beforeFiles.length; i++) {
                formData.append('product_extra_images_before[]', beforeFiles[i]);
                hasFiles = true;
            }
            fileInputs.push('#product_extra_images_before');
        }
        
        // Handle before/after images (second set)
        var before2Files = $('#product_extra_images_before2')[0] ? $('#product_extra_images_before2')[0].files : [];
        if (before2Files.length > 0) {
            for (var i = 0; i < before2Files.length; i++) {
                formData.append('product_extra_images_before2[]', before2Files[i]);
                hasFiles = true;
            }
            fileInputs.push('#product_extra_images_before2');
        }

        if (!hasFiles) {
            showMessage('Please select files to upload', 'warning');
            return;
        }

        // Show loading
        showMessage('Uploading images...', 'info');

        $.ajax({
            url: uploadProductExtraImagesUrl,
            type: "POST",
            data: formData,
            processData: false,
            contentType: false,
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            success: function(response) {
                if (response.status) {
                    // Store session ID
                    $('#product_extra_session_id').val(response.session_id);
                    
                    // Render newly uploaded images immediately
                    try { renderProductExtraImages(response.images || []); } catch(e) {}
                    
                    // Clear file inputs
                    fileInputs.forEach(function(input) {
                        $(input).val('');
                    });
                    
                    showMessage('Successful', 'success');
                } else {
                    showMessage(response.message || 'Upload failed', 'error');
                }
            },
            error: function(xhr) {
                var message = 'Upload failed';
                if (xhr.responseJSON && xhr.responseJSON.message) {
                    message = xhr.responseJSON.message;
                }
                showMessage(message, 'error');
            }
        });
    }

    function loadProductExtraImages() {
        var productId = $('[name="id"]').val();
        if (!productId) {
            // For new products, show session-based images
            var sessionId = $('#product_extra_session_id').val();
            if (sessionId) {
                // Load session-based images
                loadSessionBasedImages(sessionId);
            }
        } else {
            // For existing products, load from database
            loadProductImagesFromDatabase(productId);
        }
    }

    function loadSessionBasedImages(sessionId) {
        // For now just inform user; session images will be attached on save
        showMessage('Images uploaded. They will be linked after saving the product.', 'success');
    }

    function loadProductImagesFromDatabase(productId) {
        // Images for existing product are provided by edit handler; nothing to fetch here
    }

    // Utilities
    function getAssetUploadsBase() {
        if (typeof asset_uploads !== 'undefined' && asset_uploads) {
            return asset_uploads.endsWith('/') ? asset_uploads : asset_uploads + '/';
        }
        return '/mlstorage/uploads/';
    }

    // function renderProductExtraImages(images) {
    //     if (!images || images.length === 0) return;
    //     var container = $('#product_extra_images_container');
    //     var base = getAssetUploadsBase();
    //     images.forEach(function(image) {
    //         var id = image.id || ('temp_' + Math.random().toString(36).slice(2));
    //         var name = image.image_name || image.name || '';
    //         var alt = image.image_alt || 'Product Image';
    //         var title = image.image_title || 'Product Image';
    //         var order = image.sort_order || '';
    //         var description = image.image_description || '';
    //         var src = base + name;
    //         var card = ''+
    //         '<div class="col-md-3 mb-3 image-item" data-id="'+id+'" id="image-item-'+id+'">'+
    //           '<div class="card">'+
    //             '<div class="card-body p-2">'+
    //               '<div class="position-relative mb-2">'+
    //                 '<img src="'+ src +'" class="img-fluid rounded" style="width: 100%; height: 150px; object-fit: cover;" alt="'+ alt +'" title="'+ title +'">'+
    //                 '<button type="button" class="btn btn-sm btn-danger position-absolute top-0 end-0" style="margin: 5px;" onclick="deleteProductExtraImage('+ id +', \'"+ name +"\');"><i class="fas fa-trash"></i></button>'+
    //               '</div>'+
    //               '<div class="d-flex justify-content-between align-items-center">'+
    //                  '<div class="sort-handle" style="cursor: move;"><i class="fas fa-grip-vertical text-muted"></i></div>'
    //               '</div>'+
    //             //   '<div class="mt-2">'+
    //             //     '<label class="form-label mb-1" style="font-size:12px;">Slider Description</label>'+
    //             //     '<textarea class="form-control form-control-sm" rows="2" onblur="saveProductImageDescription('+id+', this.value)">'+ (description || '') +'</textarea>'+
    //             //   '</div>'+
    //             //   '<div class="mt-2">'+
    //             //     '<small class="text-muted d-block"><strong>Alt:</strong> '+ (alt || 'Not set') +'</small>'+
    //             //     '<small class="text-muted d-block"><strong>Title:</strong> '+ (title || 'Not set') +'</small>'+
    //             //     (order ? '<small class="text-muted d-block"><strong>Order:</strong> '+ order +'</small>' : '')+
    //             //   '</div>'+
    //             '</div>'+
    //           '</div>'+
    //         '</div>';
    //         container.append(card);
    //     });
    //     try { initProductExtraImagesSortable(); } catch(e) {}
    // }
    
    
    function renderProductExtraImages(images) {
    if (!images || images.length === 0) return;
    var container = $('#product_extra_images_container');
    var base = getAssetUploadsBase();
    images.forEach(function(image) {
        var id = image.id || ('temp_' + Math.random().toString(36).slice(2));
        var name = image.image_name || image.name || '';
        var alt = image.image_alt || 'Product Image';
        var title = image.image_title || 'Product Image';
        var order = image.sort_order || '';
        var description = image.image_description || '';
        var src = base + name;
        var card = ''+
        '<div class="col-md-3 mb-3 image-item" data-id="'+id+'" id="image-item-'+id+'">'+
          '<div class="card">'+
            '<div class="card-body p-2">'+
              '<div class="position-relative mb-2">'+
                '<img src="'+ src +'" class="img-fluid rounded" style="width: 100%; height: 150px; object-fit: cover;" alt="'+ alt +'" title="'+ title +'">'+
                '<button type="button" class="btn btn-sm btn-danger position-absolute top-0 end-0" style="margin: 5px;" onclick="deleteProductExtraImage('+ id +', \''+ name +'\');"><i class="fas fa-trash"></i></button>'+
              '</div>'+
               '<div class="d-flex justify-content-between align-items-center">'+
                 '<div class="sort-handle" style="cursor: move;"><i class="fas fa-grip-vertical text-muted"></i></div>'+
               '</div>'+
            '</div>'+
          '</div>'+
        '</div>';
        container.append(card);
    });
    try { initProductExtraImagesSortable(); } catch(e) {}
}


    window.renderProductExtraImages = renderProductExtraImages;

    function openProductExtraImageZoomModal(url) {
        $('#productExtraImageZoomImage').attr('src', url);
        $('#productExtraImageZoomModal').modal('show');
    }

    function openProductExtraImageAltTitleModal(imageId) {
        $.ajax({
            url: getProductExtraImageAltTitleUrl,
            type: "POST",
            data: {
                image_id: imageId,
                _token: $('meta[name="csrf-token"]').attr('content')
            },
            success: function(data) {
                $('#productExtraImageAltTitleForm').find('#image_id').val(imageId);
                $('#productExtraImageAltTitleForm').find('#image_alt').val(data.image_alt);
                $('#productExtraImageAltTitleForm').find('#image_title').val(data.image_title);
                $('#productExtraImageAltTitleForm').find('#image_description').val(data.image_description || '');
                $('#productExtraImageAltTitleModal').modal('show');
            },
            error: function() {
                showMessage('Error loading image details', 'error');
            }
        });
    }

    function saveProductExtraImageAltTitle() {
        $.ajax({
            url: saveProductExtraImageAltTitleUrl,
            type: "POST",
            data: $('#productExtraImageAltTitleForm').serialize() + '&_token=' + $('meta[name="csrf-token"]').attr('content'),
            success: function(response) {
                if (response.status) {
                    $('#productExtraImageAltTitleModal').modal('hide');
                    showMessage('Alt/Title/Description updated successfully', 'success');
                } else {
                    showMessage(response.message || 'Failed to update details', 'error');
                }
            },
            error: function() {
                showMessage('Error updating details', 'error');
            }
        });
    }

    // Inline description save
    function saveProductImageDescription(imageId, description) {
        $.ajax({
            url: saveProductExtraImageAltTitleUrl,
            type: 'POST',
            data: {
                image_id: imageId,
                image_description: description,
                _token: $('meta[name="csrf-token"]').attr('content')
            },
            success: function(resp){ if(resp && resp.status){ /* optional toast */ } },
            error: function(){ /* silent */ }
        });
    }

    function markProductExtraImageBeforeAfter(id, elem) {
        $.ajax({
            url: "{{ admin_url() }}saveProductExtraImagesMarkBeforeAfter",
            type: "POST",
            data: {
                id: id,
                _token: $('meta[name="csrf-token"]').attr('content')
            },
            success: function(response) {
                if (response.status) {
                    $(elem).toggleClass('btn-success btn-outline-success');
                    showMessage('Before/After status updated', 'success');
                } else {
                    showMessage('Failed to update status', 'error');
                }
            },
            error: function() {
                showMessage('Error updating status', 'error');
            }
        });
    }

    function showMessage(message, type) {
        // Simple message display - you can enhance this with your preferred notification system
        var alertClass = 'alert-' + (type === 'error' ? 'danger' : type);
        var alertHtml = '<div class="alert ' + alertClass + ' alert-dismissible fade show" role="alert">' +
            message +
            '<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>' +
            '</div>';
        
        // Remove existing alerts
        $('.alert').remove();
        
        // Add new alert
        $('.card-body').prepend(alertHtml);
        
        // Auto-hide after 5 seconds
        setTimeout(function() {
            $('.alert').fadeOut();
        }, 5000);
    }
</script>
