@if(isset($productExtraImages) && count($productExtraImages) > 0)
    <div class="row" id="product_extra_images_container">
        @foreach($productExtraImages as $image)
            <div class="col-md-3 mb-3 image-item" data-id="{{ $image->id }}" id="image-item-{{ $image->id }}">
                <div class="card">
                    <div class="card-body p-2">
                        <!-- Main Image -->
                        <div class="position-relative mb-2">
                            <img src="{{ asset_uploads($image->image_name) }}" 
                                 class="img-fluid rounded" 
                                 style="width: 100%; height: 150px; object-fit: cover; cursor: pointer;"
                                 onclick="openProductExtraImageZoomModal('{{ asset_uploads($image->image_name) }}');"
                                 alt="{{ $image->image_alt ?? 'Product Image' }}"
                                 title="{{ $image->image_title ?? 'Product Image' }}">
                            
                            <!-- Delete Button -->
                            <button type="button" 
                                    class="btn btn-sm btn-danger position-absolute top-0 end-0" 
                                    style="margin: 5px;"
                                    onclick="deleteProductExtraImage({{ $image->id }}, '{{ $image->image_name }}');">
                                <i class="fas fa-trash"></i>
                            </button>
                        </div>

                        <!-- Before/After Toggle -->
                        <div class="text-center mb-2">
                            <a onClick="markProductExtraImageBeforeAfter({{ $image->id }}, this)" 
                               href="javascript:void(0)"
                               class="btn btn-sm {{ $image->isBeforeAfter ? 'btn-success' : 'btn-outline-success' }}">
                                <i class="fas fa-exchange-alt"></i> Before/After
                            </a>
                        </div>

                        <!-- Image Controls -->
                        <div class="d-flex justify-content-between align-items-center">
                            <!-- Sort Handle -->
                            <div class="sort-handle" style="cursor: move;">
                                <i class="fas fa-grip-vertical text-muted"></i>
                            </div>
                            
                            <!-- Alt/Title Edit Button -->
                            <a title="Image Alt/Title" 
                               onClick="openProductExtraImageAltTitleModal({{ $image->id }});"
                               href="javascript:void(0)" 
                               class="btn btn-sm btn-outline-primary">
                                <i class="fas fa-edit"></i>
                            </a>
                        </div>

                        <!-- Image Info -->
                        <div class="mt-2">
                            <small class="text-muted d-block">
                                <strong>Alt:</strong> {{ $image->image_alt ?: 'Not set' }}
                            </small>
                            <small class="text-muted d-block">
                                <strong>Title:</strong> {{ $image->image_title ?: 'Not set' }}
                            </small>
                            <small class="text-muted d-block">
                                <strong>Order:</strong> {{ $image->sort_order }}
                            </small>
                        </div>
                    </div>
                </div>
            </div>
        @endforeach
    </div>
@else
    <div class="text-center py-4">
        <i class="fas fa-images fa-3x text-muted mb-3"></i>
        <p class="text-muted">No product slider images uploaded yet.</p>
        <p class="text-muted">Upload images using the file inputs above to create a product image slider.</p>
    </div>
@endif
