<div class="modal fade" id="modal_form" role="dialog" data-bs-focus="false">
    <div class="modal-dialog modal-lg">
        <form action="#" id="form" class="form-horizontal" enctype="multipart/form-data">
            <div class="modal-content">
                @csrf
                <input type="hidden" name="moduleType" id="moduleType" value="product">
                <div class="modal-header">
                    <div class="row" style="width: 100%;">
                        <div class="col-md-6">
                            <h4 class="modal-title">Edit Product</h4>
                        </div>
                        <div class="text-right col-md-6">
                            <a href="javascript:void(0);" onclick="showProductRecordUpdateHistory();"
                               class="mr-4 go-back" id="showProductRecordUpdateHistoryLink"><i class="fas fa-bars"
                                                                                              aria-hidden="true"></i>
                                History </a>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                    aria-label="Close"></button>
                        </div>
                    </div>
                </div>
                <div class="modal-body form">

                    <!-- Tabs -->
                    <ul class="nav nav-tabs" id="productTabs" role="tablist">
                        <li class="nav-item">
                            <a class="nav-link active" id="general-tab" data-bs-toggle="tab" href="#general" role="tab"
                               aria-controls="general" aria-selected="true">General</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="seo-tab" data-bs-toggle="tab" href="#seo" role="tab"
                               aria-controls="seo" aria-selected="false">SEO</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="slider-tab" data-bs-toggle="tab" href="#slider" role="tab"
                               aria-controls="slider" aria-selected="false">Slider & Media</a>
                        </li>
                    </ul>

                    <!-- Tab Content -->
                    <div class="tab-content mt-3" id="productTabsContent">

                        <!-- General Tab -->
                        <div class="tab-pane fade show active" id="general" role="tabpanel" aria-labelledby="general-tab">
                            <div class=" card-body">
                                <div class="alert alert-danger error-div" style="display:none"></div>
                                <input type="hidden" name="id" id="id" value="">
                                <div class="form-body">
                                    <div>
                                        <label class="form-label">Product Name</label>
                                        <input onchange="string_to_slug('product_name', 'product_slug');"
                                               name="product_name" placeholder="Product Name" class="form-control" type="text">
                                        <span id="product_name" style="padding-left:2px;" class="err"></span>
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label">Category</label>
                                        <select name="category_ids[]" id="category_ids" class="form-control">
                                            <option value="">-- Select Category --</option>
                                            @isset($categories)
                                                @foreach($categories as $category)
                                                    <option value="{{ $category->id }}">{{ $category->title }}</option>
                                                @endforeach
                                            @endisset
                                        </select>
                                    </div>
                                    

                                    <div class="col-sm-12 form-group">
                                        <label class="form-label">Product Visual</label>
                                        <select name="product_vs_id[]" id="product_vs_id" multiple="multiple" class="form-control">
                                            <option value="">-- Select Visual --</option>
                                            @isset($product_vss)
                                                @foreach($product_vss as $category_vss)
                                                    <option value="{{ $category_vss->id }}">{{ $category_vss->heading }}</option>
                                                @endforeach
                                            @endisset
                                        </select>
                                    </div>
                                    

                                    <div>
                                        <label for="basic-url">Page Link @php echo helptooltip('page_link'); @endphp</label>
                                        <div class="mb-2">
                                            <div class="input-group">
                                                <div class="input-group-prepend">
                                                    <span class="input-group-text" id="slug_field_base_url">
                                                        {{ url('products').'/' }}
                                                    </span>
                                                </div>
                                                <input type="text" class="form-control slug-field" name="product_slug"
                                                       placeholder="Product Page Link" onchange="check_slug('product_slug');">
                                            </div>
                                        </div>
                                        <span id="product_slug" style="padding-left:2px;" class="err"></span>
                                    </div>

                                    <div>
                                        <label class="form-label">Product Description</label>
                                        <div class="mb-2">
                                            <a href="javascript:;" data-bs-toggle="modal" data-bs-target="#media_image"
                                               class="btn btn-sm btn-info"> <i class="fas fa-cloud-download"
                                                                               aria-hidden="true"></i>
                                                Insert Image from Media</a>
                                            <a href="javascript:;" data-bs-toggle="modal" data-bs-target="#media_files"
                                               class="btn btn-sm btn-warning"> <i class="fas fa-cloud-download"
                                                                                  aria-hidden="true"></i>
                                                Insert Document from Media</a>
                                        </div>
                                        <textarea name="product_description_editor" id="product_description_editor" placeholder="Product Description" class="form-control"
                                                  type="text"></textarea>
                                        <textarea name="product_description" id="product_description1" style="display: none;"></textarea>
                                        <span id="product_description" style="padding-left:2px;" class="err"></span>
                                    </div>

                                    <div id="fea_img">
                                        <label class="form-label"> Update Product Image <span
                                                style="font-size: 12px;color: red"> max size:
                                        {{ getMaxUploadSize() }}MB </span> @php echo helptooltip('max_image_size') @endphp </label>
                                        <div id="file-field">
                                            <input type="file" name="product_img" id="module_img" class="form-control">
                                            <div id="attached_files_div"></div>
                                        </div>
                                        <span id="featured_img" style="padding-left:2px;" class="err"></span>
                                        <div id="featured_img"></div>
                                        <div class="clear"></div>
                                        <div class="mt-3 mb-3">
                                            <label class="btn btn-primary img_alt_title_label">Image Title/Alt</label>
                                            <div class="mt-3 mb-3" style="display:none;">
                                                <label class="form-label">Image Title</label>
                                                <input type="text" name="product_img_title" id="product_img_title"
                                                       class="form-control" placeholder="Product Image Title" value="">
                                                <label class="mt-3">Image Alt</label>
                                                <input type="text" name="product_img_alt" id="product_img_alt"
                                                       class="form-control" placeholder="Product Image Alt" value="">
                                            </div>
                                        </div>
                                    </div>
                                    <div id="product_img_div" style="display: none"></div>
                                </div>
                            </div>
                        </div>

                        <!-- SEO Tab -->
                        <div class="tab-pane fade" id="seo" role="tabpanel" aria-labelledby="seo-tab">
                            @include('back.common_views.seo_fields', [
                                'meta_title' => '',
                                'meta_keywords' => '',
                                'meta_description' => '',
                                'canonical_url' => '',
                            ])
                        </div>

                        <!-- Slider & Media Tab -->
                        <div class="tab-pane fade" id="slider" role="tabpanel" aria-labelledby="slider-tab">
                            <div class="mt-3 mb-3">
                                <label class="form-label">Slider Description (WYSIWYG)</label>
                                <div class="mb-2">
                                    <a href="javascript:;" data-bs-toggle="modal" data-bs-target="#media_image" class="btn btn-sm btn-info"> <i class="fas fa-cloud-download" aria-hidden="true"></i> Insert Image from Media</a>
                                    <a href="javascript:;" data-bs-toggle="modal" data-bs-target="#media_files" class="btn btn-sm btn-warning"> <i class="fas fa-cloud-download" aria-hidden="true"></i> Insert Document from Media</a>
                                </div>
                                <textarea name="slider_description_editor" id="slider_description_editor" placeholder="Slider Description" class="form-control" type="text"></textarea>
                                <textarea name="slider_description" id="slider_description" style="display: none;"></textarea>
                            </div>

                            <div class="mt-3 mb-3">
                                <label class="form-label">Product Color Image</label>
                                <input type="file" id="imageUpload" name="product_color_image" accept="image/*" class="form-control">
                                <div class="mt-3" id="imageContainer">
                                    
                                </div>
                            </div>
                            
                       <!-- Brand Logo -->
<div class="mt-3 mb-3">
  <label class="form-label">Brand Logo</label>
  <input type="file" id="brandImage" name="brand_logo_image" accept="image/*" class="form-control">
  
  <!-- Keep old image path for editing -->
  <input type="hidden" name="brand_logo_image_old" id="brand_logo_image_old" value="">

  <!-- Preview -->
  <div class="mt-3" id="brandLogoPreview">
    <!-- Image preview goes here -->
  </div>
</div>

                            

                            <div class="mt-3 mb-3">
                                <label class="form-label">Product Slider Images</label>
                                <input type="hidden" id="product_extra_session_id" name="session_id" value="">
                                <div class="row g-3">
                                    <div class="col-md-12">
                                        <input type="file" id="product_extra_images" class="form-control" multiple>
                                        <small class="text-muted">Upload one or more images for the product slider. Max size: {{ getMaxUploadSize() }}MB</small>
                                    </div>
                                    <div class="col-md-12">
                                        <button type="button" class="btn btn-secondary" onclick="uploadProductExtraImages()">Upload Slider Images</button>
                                    </div>
                                    
                                    <div class="mt-3 mb-3">
    <label class="form-label">Product PDF <span class="text-muted">(Optional, max size: 5MB)</span></label>
    <input type="file" name="product_pdf" id="product_pdf" class="form-control" accept="application/pdf">
    <small class="text-muted">Upload a PDF file for this product.</small>
</div>

<!-- Preview / Existing PDF -->


<!-- Sizes and Colors -->
<div class="mt-3 mb-3">
    <label class="form-label">Sizes & Colors</label>
    <input type="text" name="sizes_colors" id="sizes_colors" class="form-control" placeholder="Add sizes and colors"  value="{{ old('sizes_colors', $product->sizes_colors ?? '') }}">

</div>






                                </div>
                                <div class="mt-3">
                                    <div id="product_extra_images_container" class="row">
                                        <!-- Uploaded slider images will appear here -->
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div><!-- tab-content -->

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Cancel</button>
                    <button type="button" id="btnSave" onclick="save()" class="btn btn-success">Save
                        Record</button>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- keep your media popups + scripts as they were below -->
@include('back.product.product_extra_images.product_extra_images_js')
@include('back.product.product_extra_images.product_extra_images_popups')

<script>
document.getElementById('imageUpload').addEventListener('change', function(event) {
    let reader = new FileReader();
    reader.onload = function(){
        let preview = document.getElementById('previewImage');
        preview.src = reader.result;
        preview.style.display = 'block';
    }
    reader.readAsDataURL(event.target.files[0]);
});

</script>







