<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        if (Schema::hasTable('products') && !Schema::hasColumn('products', 'slider_description')) {
            Schema::table('products', function (Blueprint $table) {
                $table->longText('slider_description')->nullable()->after('product_description');
            });
        }
    }

    public function down(): void
    {
        if (Schema::hasTable('products') && Schema::hasColumn('products', 'slider_description')) {
            Schema::table('products', function (Blueprint $table) {
                $table->dropColumn('slider_description');
            });
        }
    }
};


