<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        if (Schema::hasTable('product_extra_images') && !Schema::hasColumn('product_extra_images', 'image_description')) {
            Schema::table('product_extra_images', function (Blueprint $table) {
                $table->text('image_description')->nullable()->after('image_title');
            });
        }
    }

    public function down(): void
    {
        if (Schema::hasTable('product_extra_images') && Schema::hasColumn('product_extra_images', 'image_description')) {
            Schema::table('product_extra_images', function (Blueprint $table) {
                $table->dropColumn('image_description');
            });
        }
    }
};


