<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (!Schema::hasTable('category_product')) {
            Schema::create('category_product', function (Blueprint $table) {
                $table->unsignedInteger('category_id');
                $table->unsignedInteger('product_id');
                $table->primary(['category_id', 'product_id']);
                $table->index(['product_id', 'category_id'], 'idx_product_category');
            });
        }
    }

    public function down(): void
    {
        Schema::dropIfExists('category_product');
    }
};


