<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('product_extra_images', function (Blueprint $table) {
            $table->id();
            $table->string('image_name')->nullable();
            $table->string('image_name2')->nullable();
            $table->boolean('isBeforeAfter')->default(false);
            $table->boolean('isBeforeAfterHaveTwoImages')->default(false);
            $table->unsignedBigInteger('product_id')->nullable();
            $table->string('session_id')->nullable();
            $table->string('image_alt')->nullable();
            $table->string('image_title')->nullable();
            $table->integer('sort_order')->default(0);
            $table->timestamps();
            $table->softDeletes();

            $table->foreign('product_id')->references('id')->on('products')->onDelete('cascade');
            $table->index(['product_id', 'sort_order']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('product_extra_images');
    }
};
