<?php

namespace App\Models\Back;

use Illuminate\Database\Eloquent\Model;

class ProductExtraImage extends Model
{
    protected $table = 'product_extra_images';

    public $timestamps = false;

    protected $guarded = [];

    protected $casts = [
        'isBeforeAfter' => 'boolean',
        'isBeforeAfterHaveTwoImages' => 'boolean',
        'sort_order' => 'integer',
        'product_id' => 'integer',
    ];

    protected $fillable = [
        'product_id',
        'session_id',
        'image_name',
        'image_alt',
        'image_title',
        'image_description',
        'isBeforeAfter',
        'isBeforeAfterHaveTwoImages',
        'sort_order',
    ];

    public function scopeSorted($query)
    {
        return $query->orderBy('sort_order', 'ASC')->orderBy('id', 'ASC');
    }
}


