<?php

namespace App\Models\Back;

use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    public $timestamps = false;
    protected $primaryKey = 'id';

    public function categories()
    {
        return $this->belongsToMany(Category::class, 'category_product', 'product_id', 'category_id');
    }

    public function productExtraImages()
    {
        return $this->hasMany(ProductExtraImage::class, 'product_id', 'id');
    }
}
