<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class OrderMail extends Mailable
{
    use Queueable;
    use SerializesModels;
    public $data;
    public $product_data;
    private $ip;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($data,$product_data, $ip)
    {
        $this->data = $data;
        $this->product_data=$product_data;
        $this->ip = $ip;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $data = $this->data;
        $product_data=$this->product_data;
        $ip = $this->ip;

        return $this->subject(FindInsettingArr('business_name').' | Order Form Submitted')
        ->replyTo($data['email'], $data['name'])
        ->view('mail.order', compact('data', 'ip','product_data'));
    }
}
