<?php
// app/Http/Controllers/Front/ProductController.php
namespace App\Http\Controllers\Front;
use    App\Models\Back\BlogPost;
use App\Models\Back\BlogCategory;
use App\Http\Controllers\Controller;
use App\Models\Back\Product;
use App\Models\Back\CmsModuleData;
// adjust if namespace differsCmsModuleData
use App\Models\Back\Metadata;
use App\Models\Back\RecordUpdateHistory;
use App\Models\Back\Category;
class ProductController extends Controller
{
    public function index()
    {
        $postData = CmsModuleData::where('sts', 1)->where('post_slug', 'products')->first();

        $seoArr = ['title' => 'Products | ' . FindInsettingArr('business_name')];
        if ($postData) {
            $seoArr = SeoArray($postData);
        }

        // Use scopes if you have them; else fallback below
        $allProducts = method_exists(Product::class, 'scopeActive')
            ? Product::active()->sorted()->get()
            : Product::where('sts', 1)->orderBy('item_order', 'ASC')->get();
            
            
        $siteKeyData = Metadata::where('data_key', 'recaptcha_site_key')->first();
            $siteKey = $siteKeyData->val1;    

        return view('front.products.index', compact('seoArr', 'allProducts','siteKey'));
    }

    public function show($slug)
    {
       
$product = Product::where('product_slug', $slug)->where('sts', 1)->firstOrFail();
      //  $get_all_product_colors=getModuleData(50, 50);
$get_all_product_colors = CmsModuleData::where('cms_module_id', 50)
    ->where('additional_field_8', $product->id)
    ->where('sts', 1) // only active records
    ->get();

// dd($get_all_product_colors);
        // Get product extra images for slider
        $productSliderImages = getProductSliderImages($product->id);
        $productBeforeAfterImages = getProductBeforeAfterImages($product->id);

        $seoArr = ['title' => $product->product_name . ' | ' . FindInsettingArr('business_name')];
        return view('front.products.show', compact('seoArr', 'product', 'get_all_product_colors','productSliderImages', 'productBeforeAfterImages'));
    }
    
    
    
private $module_id = 50;

public function color()
{
    // If you actually want "all colors", drop the product filter entirely.
    $get_all_product_colors = CmsModuleData::where('cms_module_id', $this->module_id)
        ->where('sts', 1) 
        ->get();

    $postData = CmsModuleData::where('sts', 1) // keep consistent with above
        ->where('post_slug', 'product-colors')
        ->first();

    $seoArr = ['title' => 'Product Colors | ' . FindInsettingArr('business_name')];
    if (!empty($postData)) {
        $seoArr = SeoArray($postData);
    }

    // IMPORTANT: no '$' inside compact keys
    return view('front.products.product_colors.index', compact('seoArr', 'postData', 'get_all_product_colors'));
}

public function color_show($product,$color)
{
    

   $product = Product::where('product_slug', $product)->where('sts', 1)->firstOrFail();
   
   $color_slug='product-colors/'.$color;
    $result = CmsModuleData::where('cms_module_id',50)->where('additional_field_8',$product->id)->where('post_slug',$color_slug)->firstOrFail();

    // This appears to be the product id foreign-key
    $productId = $product->id;

    // Use $productId, not $product->id
    $get_all_product_colors = CmsModuleData::where('cms_module_id','50')
        ->where('additional_field_8', $productId)
        ->where('sts', 1) // or 'active'
        ->get();
        
$blogData = BlogPost::where('sts', 1)->orderBy('dated', 'DESC')->paginate(10);
		$blog_categories = BlogCategory::all();
    $seoArr = ['title' => $result->title . ' | ' . FindInsettingArr('business_name')];

    return view('front.products.product_colors.show', compact('seoArr', 'get_all_product_colors', 'result','blogData','blog_categories', 'productId','product'));
}


public function ProductCats($slug)
{
    $slug = str_replace('-', ' ', $slug);

    $category = Category::where('title', $slug)->first();

    if (!$category) {
        return view('front.home.404');
    }

    // Paginate only products that belong to this category
    $perPage = 12;
    $allProducts = $category->products()       // <- use relationship query, not ->products (collection)
        ->where('sts', 1)
        ->orderBy('item_order', 'ASC')
        ->paginate($perPage);

    $seoArr = ['title' => $category->title . ' | ' . FindInsettingArr('business_name')];

    $siteKeyData = Metadata::where('data_key', 'recaptcha_site_key')->first();
    $siteKey = $siteKeyData->val1 ?? null;

    return view('front.products.category', compact('seoArr', 'category', 'allProducts', 'siteKey'));
}




public function visuals()
{
    // If you actually want "all colors", drop the product filter entirely.
    $get_all_visuals =CmsModuleData::where('cms_module_id','52')
        ->where('sts', 1) // or ->where('sts', 'active') if that's your schema
        ->get();

    $postData = CmsModuleData::where('sts', 1) // keep consistent with above
        ->where('post_slug', 'visuals')
        ->first();

    $seoArr = ['title' => 'Visuals | ' . FindInsettingArr('business_name')];
    
    if (!empty($postData)) {
        $seoArr = SeoArray($postData);
    }

    // IMPORTANT: no '$' inside compact keys
    return view('front.products.visuals', compact('seoArr', 'postData', 'get_all_visuals'));
}


public function visuals_show($slug)
{
    
   
    $slug = str_replace('-', ' ', $slug);
    $result = CmsModuleData::where('cms_module_id',53)->where('heading',$slug)->first();
    
    if($result ==null)
    {
        return view('front.home.404');
    }
    
//$get_all_product_visuals=Product::where('product_vs_id',$result->id)->get();

$get_all_product_visuals = Product::where('product_vs_id', 'LIKE', '%"'.$result->id.'"%')->get();

    
 
       $siteKeyData = Metadata::where('data_key', 'recaptcha_site_key')->first();
            $siteKey = $siteKeyData->val1;
    
   
$seoArr = ['title' =>$result->heading .' | ' . FindInsettingArr('business_name')];
    
            
$blogData = BlogPost::where('sts', 1)->orderBy('dated', 'DESC')->paginate(10);
		$blog_categories = BlogCategory::all();
    $seoArr = ['title' => $result->title . ' | ' . FindInsettingArr('business_name')];
    
    return view('front.products.visuals_show', compact('seoArr', 'result','blogData','blog_categories','get_all_product_visuals','siteKey'));
}




public function VisualsCats($slug)
{
    
   
    
    $slug = 'visuals/'.$slug;
    
     $get_single_visual = CmsModuleData::where('cms_module_id', 52)
     
    ->where('post_slug',$slug)
    ->first();
    
   // dd($get_single_visual);
    
    // $category = Category::where('title',$slug)->with('visuals')->first();
    
    // if($category ==null)
    // {
    //     return view('front.home.404');
    // }
    
    $blogData = BlogPost::where('sts', 1)->orderBy('dated', 'DESC')->paginate(10);
		$blog_categories = BlogCategory::all();
  //  $seoArr = ['title' => $result->title . ' | ' . FindInsettingArr('business_name')];
    
    $siteKeyData = Metadata::where('data_key', 'recaptcha_site_key')->first();
            $siteKey = $siteKeyData->val1;

    return view('front.products.visuals_single', compact('siteKey','get_single_visual','blogData','blog_categories'));
}

}
