<?php

namespace App\Http\Controllers\Front;

use Auth;
use App\Models\Back\Album;
use App\Models\Back\Image;
use App\Models\Back\Service;
use Illuminate\Http\Request;
use App\Mail\OrderMail;
use Illuminate\Support\Facades\Mail;
use App\Models\Back\BlogPost;
use App\Models\Back\MenuType;
use App\Models\Back\Metadata;
use App\Models\Back\CmsModule;
use App\Models\Back\Setting;
use Illuminate\Support\Carbon;
use App\Models\Back\Subscribers;
use App\Models\Back\BlogCategory;
use App\Models\Back\CmsModuleData;
use Illuminate\Support\Facades\URL;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Session;
use App\Models\Back\Product;
use App\Models\Back\Category;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\Redirect;
use App\Models\Back\ContactUsRequest;

class HomeController extends Controller
{

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        // if (Cache::has('web_index_page') && Auth::check() == false) {
        //     return Cache::get('web_index_page');
        // }

        $news_results =  get_all(32, NULL, 3);  // (limit,start,module_id)
        $tesimonialsArr = get_alls(15, NULL, 22);
        $seoArr = getSeoArrayModule(151);
        $blogData = BlogPost::where('sts', 1)->orderBy('dated', 'DESC')->limit(3)->get();
        $get_all_banner = getModuleData(2);
        $get_all_features = getModuleData(35, 4);
        $get_all_services = Service::where('is_featured', 1)->active()->sorted()->get();
        
        $hasPivot = Schema::hasTable('category_product');
        
        $get_all_products = $hasPivot
            ? Product::where('sts', 1)->where('is_featured', 'Yes')->with(['categories:id,slug,title'])->get()
            
            : Product::where('sts', 1)->get();
        $product_categories = $hasPivot ? Category::orderBy('orderr', 'ASC')->get() : collect([]);
        $get_all_testimonials = getModuleData(22, 10);
        $get_all_faqs = getModuleData(19, 10);
        $get_all_partners = getModuleData(34, 10);
        $get_all_new_product= CmsModuleData::where('cms_module_id','49')
        ->where('sts', 1) // or 'active'
        ->get();
      //  $get_all_new_product = getModuleData(49, 10);
        $get_all_product_colors=getModuleData(50, 50);
        $albums = Album::paginate(20);
        $images = Image::paginate(20);
          $siteKeyData = Metadata::where('data_key', 'recaptcha_site_key')->first();
            $siteKey = $siteKeyData->val1; 
        $html = view('front.home.index', compact('news_results', 'seoArr', 'get_all_products','get_all_product_colors','tesimonialsArr', 'get_all_new_product','blogData', 'get_all_banner', 'get_all_features', 'get_all_services', 'albums', 'images', 'get_all_testimonials', 'get_all_faqs', 'get_all_partners','siteKey', 'product_categories'))->render();
        $parser = \WyriHaximus\HtmlCompress\Factory::construct();
        $html = $parser->compress($html);
        
        // if (Auth::check() == false) {
        //     Cache::put('web_index_page', $html, cacheTime());
        // }
        
        return $html;
    }
    public function aboutUs()
    {
        if (Cache::has('page_about_us_104') && Auth::check() == false) {
            return Cache::get('page_about_us_104');
        }
        $about = CmsModuleData::where('id', '104')->firstOrFail();
        $seoArr = SeoArray($about);

        $cmsModuleDataImages = getCmsModuleDataImagesById(104);
        $cmsModuleVideos = getCmsModuleVideosById(104);

        $html = view('front.home.about-us', compact('about', 'seoArr', 'cmsModuleDataImages', 'cmsModuleVideos'))->render();
        $parser = \WyriHaximus\HtmlCompress\Factory::construct();
        $html = $parser->compress($html);
        if (Auth::check() == false) {
            Cache::put('page_about_us_104', $html, cacheTime());
        }
        return $html;
    }
    public function FAQs()
    {
        if (Cache::has('page_272') && Auth::check() == false) {
            return Cache::get('page_272');
        }
        $about = CmsModuleData::where('id', '272')->firstOrFail();
        $seoArr = SeoArray($about);
        $faqsArr = get_alls(500, 0, 19);
        $html = view('front.home.faqs', compact('about', 'seoArr', 'faqsArr'))->render();
        $parser = \WyriHaximus\HtmlCompress\Factory::construct();
        $html = $parser->compress($html);
        if (Auth::check() == false) {
            Cache::put('page_272', $html, cacheTime());
        }
        return $html;
    }

 public function cartpage()
    {
        // if (Cache::has('page_303') && Auth::check() == false) {
        //     return Cache::get('page_303');
        // }
        $page = CmsModuleData::where('id', '303')->firstOrFail();
        $seoArr = SeoArray($page);
        $cart = session()->get('cart', []);
         $siteKeyData = Metadata::where('data_key', 'recaptcha_site_key')->first();
            $siteKey = $siteKeyData->val1;
        $html =  view('front.home.cart-page', compact('page','siteKey', 'seoArr','cart'))->render();
        $parser = \WyriHaximus\HtmlCompress\Factory::construct();
        $html = $parser->compress($html);
        if (Auth::check() == false) {
            Cache::put('page_303', $html, cacheTime());
        }
        return $html;
    }
    
    
    
    // Add product to cart
 public function add(Request $request, $id)
{
    $product = Product::findOrFail($id);

    $cart = session()->get('cart', []);

    if (isset($cart[$id])) {
        $cart[$id]['quantity']++;
    } else {
        $cart[$id] = [
            'name'     => $product->product_name,
            'image'    => $product->product_img ?? null,
            'quantity' => 1,
            'category' => $product->categories->pluck('title')->implode(', ')
        ];
    }

    session()->put('cart', $cart);

    $cartCount = collect($cart)->sum('quantity');

    if ($request->ajax()) {
        return response()->json([
            'status' => 'success',
            'cart_count' => $cartCount
        ]);
    }

    return redirect()->route('basket')->with('success', 'Product added to cart!');
}

    
 public function remove($id)
{
    $cart = session()->get('cart', []);

    if (isset($cart[$id])) {
        unset($cart[$id]);
        
        session()->put('cart', $cart);
    }

    return redirect()->route('basket')->with('success', 'Product removed from cart!');
}


public function submitOrder(Request $request)
{
    // Validation rules & messages
    
    
    
    
    $validationRules = [
        'name'     => 'required|string|max:255',
        'email'    => 'required|email',
        'phone'    => 'required|string|max:20',
        'message'  => 'nullable|string',
        'products' => 'required|array',
    ];

    $validationMessages = [
        'name.required'  => 'Name is required',
        'email.required' => 'Email is required',
        'email.email'    => 'Valid Email is required',
        'phone.required' => 'Phone is required',
    ];

    $validatedData = $request->validate($validationRules, $validationMessages);

    // Negative keywords check
    $negativeKeywordsMetaData = Metadata::where('data_key', 'negative_keywords')->first();
    $negativeKeywords = $negativeKeywordsMetaData ? explode(',', $negativeKeywordsMetaData->val1) : [];
    $sentenceToCheck = $request->name . ' ' . $request->email . ' ' . $request->phone . ' ' . $request->message;

    $hasNegativeKeyword = false;
    foreach ($negativeKeywords as $negativeKeyword) {
        if (stripos($sentenceToCheck, trim($negativeKeyword)) !== false) {
            $hasNegativeKeyword = true;
            break;
        }
    }

    // ReCAPTCHA verification
    $secretKeyData = Metadata::where('data_key', 'recaptcha_secret_key')->first();
    $recaptcha_secret = $secretKeyData ? trim($secretKeyData->val1, " ") : '';
    $recaptcha_response = $request->get('g-recaptcha-response');

    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => 'https://www.google.com/recaptcha/api/siteverify',
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => [
            'secret'   => $recaptcha_secret,
            'response' => $recaptcha_response,
            'remoteip' => $_SERVER['REMOTE_ADDR'] ?? null,
        ],
        CURLOPT_RETURNTRANSFER => true,
    ]);

    $output = curl_exec($ch);
    curl_close($ch);
    $json = json_decode($output);

    if (!$json || empty($json->success)) {
        return response()->json(['status' => false, 'error' => 'Select I Am Not Robot']);
    }

    // Send email if no negative keywords
    if ($hasNegativeKeyword === false) {
        
        
    $products_list=[];
    if(isset($request->products))
    {
        foreach($request->products as $key=> $single_product)
        {
           $products_list[]=$key; 
        }
        
    }
    
    
    
            $contactUsRequest = new ContactUsRequest();
            $contactUsRequest->name = $request->name;
            $contactUsRequest->email = $request->email;
            $contactUsRequest->phone = $request->phone;
            $contactUsRequest->comments = $request->message;
            $contactUsRequest->ip = $request->ip();
            $contactUsRequest->product_list_ids = json_encode($products_list);
            $contactUsRequest->dated = date('Y-m-d H:i:s');
            $contactUsRequest->save();
            
            // $product_data = Product::whereIn('id',$products_list)->get();
             $product_data = Product::select('products.*', 'categories.title as category_name')
    ->join('category_product', 'products.id', '=', 'category_product.product_id')
    ->join('categories', 'categories.id', '=', 'category_product.category_id')
    ->whereIn('products.id', $products_list)
    ->groupBy('products.id')
    ->get();
            
           
            
             session()->put('cart',[]);

        $contact_emails = Setting::first();

        $toArray  = $contact_emails && $contact_emails->to_email ? explode(',', $contact_emails->to_email) : [];
        $ccArray  = $contact_emails && $contact_emails->cc_email ? array_filter(explode(',', $contact_emails->cc_email)) : [];
        $bccArray = $contact_emails && $contact_emails->bcc_email ? array_filter(explode(',', $contact_emails->bcc_email)) : [];

        $mail = Mail::to($toArray);

        if (!empty($ccArray)) {
            $mail->cc($ccArray);
        }
        if (!empty($bccArray)) {
            $mail->bcc($bccArray);
        }

        $mail->send(new OrderMail($request->all(),$product_data, $request->ip()));

        return response()->json(['status' => true, 'error' => 'Thank you, your order has been submitted successfully!']);
    } else {
        return response()->json(['status' => false, 'error' => 'Email cannot be sent; Unwanted Keyword detected']);
    }
}

    
 public function environment()
    {
        // if (Cache::has('page_304') && Auth::check() == false) {
        //     return Cache::get('page_304');
        // }
        
        $page = CmsModuleData::where('id', '304')->firstOrFail();
        $cmsModuleDataImages = getCmsModuleDataImagesById(304);
        
        $seoArr = SeoArray($page);
        
        
        $html =  view('front.home.environment', compact('page', 'seoArr','cmsModuleDataImages', 'page'))->render();
        
        $parser = \WyriHaximus\HtmlCompress\Factory::construct();
        $html = $parser->compress($html);
        if (Auth::check() == false) {
            
            Cache::put('page_304', $html, cacheTime());
        }
        return $html;
    }


    public function Portfolio()
    {
        if (Cache::has('page_223') && Auth::check() == false) {
            return Cache::get('page_223');
        }
        $page = CmsModuleData::where('id', '223')->firstOrFail();
        $seoArr = SeoArray($page);
        $portfoliArr = get_alls(8000, 0, 36);
        $html =  view('front.home.portfolio', compact('page', 'seoArr', 'portfoliArr'))->render();
        $parser = \WyriHaximus\HtmlCompress\Factory::construct();
        $html = $parser->compress($html);
        if (Auth::check() == false) {
            Cache::put('page_223', $html, cacheTime());
        }
        return $html;
    }

    public function page($slug)
    {
        
        
        
        
        if (Cache::has($slug)) {
            return Cache::get($slug);
        }
        
        
        
        $data = CmsModuleData::where('post_slug', $slug)->first();
        
        if ($data != null) {
            
            
            $module = CmsModule::where('type', 'cms')->first();
            $menu_types = MenuType::orderBy('id', 'ASC')->get();
            $seoArr = getSeoArrayModule($data->id);
            $cmsModuleDataImages = getCmsModuleDataImagesBySlug($slug);
            $cmsModuleVideos = getCmsModuleVideosBySlug($slug);


            $editPageID = $data->id;
            if ($data->cms_module_id == 33) {
                return view('front.home.full', compact('data', 'seoArr', 'module', 'menu_types', 'editPageID', 'cmsModuleDataImages', 'cmsModuleVideos'));
            } else {
                // return view('front.home.page', compact('data', 'seoArr','module','menu_types','editPageID'));
                $html = view('front.home.page', compact('data', 'seoArr', 'module', 'menu_types', 'editPageID', 'cmsModuleDataImages', 'cmsModuleVideos'))->render();
                $parser = \WyriHaximus\HtmlCompress\Factory::construct();
                $html = $parser->compress($html);
                Cache::put($slug, $html, cacheTime());
                return $html;
            }
            $html = view('front.home.page', compact('data', 'seoArr', 'module', 'menu_types', 'editPageID'))->render();
            $parser = \WyriHaximus\HtmlCompress\Factory::construct();
            $html = $parser->compress($html);
            Cache::put($slug, $html, cacheTime());
            return $html;
        } else {
            $BlogPost = BlogPost::where('post_slug', $slug)->where('sts', 1)->first();
            if ($BlogPost) {

                $obj_result = BlogPost::with('author', 'comments')->where('post_slug', $slug)->first();
                if (isset($obj_result->title)) {
                    $seoArr = getSeoArrayBlog($obj_result->id);
                    $blog_post_details = $obj_result;
                    $blog_comments = $obj_result->comments;
                    $blog_categories = BlogCategory::all();
                    return view('front.blog.show', compact('seoArr', 'blog_post_details', 'blog_comments', 'blog_categories'));
                }
            } {
                $seoArr = array('title' => '404 Not found ');
                return view('front.home.404', compact('seoArr'));
            }
        }
    }
    public function Other_pages($parent, $slug)
    {
        $dataArr = get_one($parent, $slug);
        if (isset($dataArr['heading'])) {

            $data = (object)$dataArr;
            $seoArr = SeoArray($data);
            $editPageID = $data->id;
            return view('front.home.other', compact('data', 'seoArr', 'module', 'menu_types', 'editPageID'));
        } else {
            $seoArr = array('title' => '404 Not found ');
            return view('front.home.404', compact('seoArr'));
        }
    }
    public function login()
    {
        $seoArr = array('title' => 'Welcome to ' . FindInsettingArr('business_name'));
        return view('front.member.login', compact('seoArr'));
    }
    public function signup()
    {
        $seoArr = array('title' => 'Welcome to ' . FindInsettingArr('business_name'));
        return view('front.member.register', compact('seoArr'));
    }
    public function maintenance()
    {
        $settingsArr = \App\Models\Back\Setting::find(1);
        echo $settingsArr->web_down_msg;
    }
    public function block(Request $request)
    {
        $data = Metadata::where('data_key', 'web_blocked_msg')->first();
        $seoArr = array('title' => 'Welcome to ' . FindInsettingArr('business_name'));
        return view('front.home.error', compact('data', 'seoArr'));
    }
    public function addSubscriber(Request $request)
    {

        $valid_error = $this->validate($request, [
            'email' => 'required|unique:subscribers'
        ]);
        if (isset($valid_error)) {
            $subscriber = new Subscribers();
            $subscriber->email = $request->email;
            $subscriber->save();
            Session::flash('added_subscriber', true);
        } else {
            Session::flash('subscriber_error', true);
        }

        //return redirect(url()->previous().'#subscribe');
        return back();
    }
 public function search(Request $request)
{
    $query = $request->input('query');

    // If query exists, search products
    if ($query) {
        $allProducts = Product::where('product_name', 'like', "%{$query}%")
            ->when(method_exists(Product::class, 'scopeActive'), function ($q) {
                $q->active()->sorted();
            }, function ($q) {
                $q->where('sts', 1)->orderBy('item_order', 'ASC');
            })
            ->get();
    } else {
        // If no query, return all products
        $allProducts = method_exists(Product::class, 'scopeActive')
            ? Product::active()->sorted()->get()
            : Product::where('sts', 1)->orderBy('item_order', 'ASC')->get();
    }

    return view('front/products.index', compact('allProducts', 'query'));
}


public function suggest(Request $request)
{
    $query = $request->input('query');
    $suggestions = Product::where('product_name', 'like', "%{$query}%")
        ->limit(5)
        ->pluck('name');
    return response()->json($suggestions);
}





}
