<?php

namespace App\Http\Controllers\Front;
use App\Mail\ContactMain;
use App\Http\Controllers\Controller;
use App\Models\Back\Setting;
use App\Models\Back\Metadata;
use App\Models\Back\CmsModuleData;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;

class ContactMainController extends Controller
{
    public function index(Request $request)
    {
        if (isIpBlocked($request->ip())) {
            return redirect('/block');
        }
        $seoArr = getSeoArrayModule(118);
        $editPageID = 118;
        $data = CmsModuleData::find(118);
        
            $siteKeyData = Metadata::where('data_key', 'recaptcha_site_key')->first();
            $siteKey = $siteKeyData->val1;
            
        return view('front.contact_us.index', compact('seoArr', 'data', 'editPageID','siteKey'));
    }

    public function save(Request $request)
    {
        
        $validationRules = [
             'name'      => 'required|string|max:100',
            'email'     => 'required|email',
            'phone'     => 'required|string|max:20',
            'message'   => 'nullable|string',
           
        ];

        $validationMessages = [
            'name.required' => 'Name is required',
        
            'email.required' => 'Email is required',
            'email.email' => 'Valid Email is required',
          
            'phone.required' => 'Phone is required',
        ];
        
        $validatedData = $request->validate($validationRules, $validationMessages);

        $negativeKeywordsMetaData = Metadata::where('data_key', 'negative_keywords')->first();
        $negativeKeywords = explode(',', $negativeKeywordsMetaData->val1);
        $sentenceToCheck = $request->name . ' ' . $request->email . ' ' . $request->phone . ' ' . $request->comments;
        $hasNegativeKeyword = false;
        if (count($negativeKeywords) > 0) {
            foreach ($negativeKeywords as $negativeKeyword) {
                if (strpos($sentenceToCheck, $negativeKeyword) !== false) {
                    $hasNegativeKeyword = true;
                }
            }
        }
        
        $recaptcha_url = 'https://www.google.com/recaptcha/api/siteverify';
        
         $secretKeyData = Metadata::where('data_key', 'recaptcha_secret_key')->first();
            $recaptcha_secret = trim($secretKeyData->val1," ");

        $recaptcha_response = $request->get('g-recaptcha-response');
        $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL => 'https://www.google.com/recaptcha/api/siteverify',
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => [
                'secret' => $recaptcha_secret,
                'response' => $recaptcha_response,
                'remoteip' => $_SERVER['REMOTE_ADDR']
            ],
            CURLOPT_RETURNTRANSFER => true
        ]);
        
        $output = curl_exec($ch);
        curl_close($ch);
        $json = json_decode($output);
        if ($json->success!= 'true') {
            return response()->json(['status' => false, 'error' => 'Select I Am Not Robot']);
        }
        
        if ($hasNegativeKeyword === false) {


        

            $contact_emails = Setting::first();
            $toArray = explode(',', $contact_emails->to_email);
            $ccArray = explode(',', $contact_emails->cc_email);
            $bccArray = explode(',', $contact_emails->bcc_email);
            $mail = Mail::to($toArray);
            
            
        foreach ($ccArray as $key => $value) {
        if ($value == "" || $value == NULL) {
        unset($ccArray[$key]);
        }
        }
        foreach ($bccArray as $key => $value) {
            if ($value == "" || $value == NULL) {
                unset($bccArray[$key]);
            }
        }
        
        $mail = Mail::to($toArray);
        
        if(!empty($ccArray))
        {
          $mail->cc($ccArray);  
        }
         if(!empty($bccArray))
        {
          $mail->bcc($bccArray);
        }

       // $mail->send(new ContactUs($request->all(), $request->ip()));
       $mail->send(new ContactMain($request->all(), $request->ip()));
             return response()->json(['status' => true, 'error' => 'Thank you, your message has been sent']);

        } else {
            /* echo json_encode(['status' => false, 'error' => 'Email can not be sent; Unwanted Keyword detected']); */
             return response()->json(['status' => true, 'error' => 'Thank you, your message has been sent!']);
        }
    }

}
