<?php

namespace App\Http\Controllers\Back;

use App\Http\Controllers\Controller;
use App\Models\Back\Product;
use App\Models\Back\Category;
use App\Models\Back\ProductExtraImage;
use Illuminate\Support\Facades\Schema;
use Illuminate\Http\Request;
use App\Models\Back\CmsModuleData;
use Illuminate\Support\Facades\Validator;

class ProductController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $title = FindInsettingArr('business_name') . ': PRODUCTS\'s Management';
        $msg = '';
        $products = Product::orderBy('item_order', 'ASC')->get();
        $categories = Schema::hasTable('categories') ? Category::orderBy('title', 'ASC')->get() : collect([]);
        
        // Get media data for WYSIWYG editor
        $albumsObj = $this->get_images();
        $filesObj = $this->filesObj();
        
         $product_vss=CmsModuleData::where('cms_module_id','53')->get();
        
        return view('back.product.index', compact('products', 'title', 'msg', 'categories', 'albumsObj', 'filesObj','product_vss'));
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {
        $list_order = $request->list_order;
        $list = explode(',', $list_order);
        $i = 1;
        print_r($list);
        foreach ($list as $id) {
            $product = Product::find($id);
            $product->item_order = $i;
            $product->save();
            ++$i;
            echo $i . ' ' . $id;
        }
    }
    /**
     * Store a newly created resource in storage.
     *
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
{
    $validator = Validator::make($request->all(), [
        'product_name' => 'required',
        'product_slug' => 'required',
        'product_description' => 'required',
    ]);

    if ($validator->passes()) {
        $product = new Product();
        $product->product_name = $request->product_name;
        $product->product_slug = $request->product_slug;
        $product->product_description = $request->product_description;
        
        
        $product->product_vs_id=json_encode($request->product_vs_id) ?? "";

        if (Schema::hasColumn('products', 'slider_description')) {
            $product->slider_description = $request->slider_description;
        }
        
        

        $product->meta_title = $request->meta_title;
        $product->meta_keywords = $request->meta_keywords;
        $product->meta_description = $request->meta_description;
        $product->sizes_colors = $request->input('sizes_colors'); // Store HTML
        $product->canonical_url = $request->canonical_url;

        // Featured Image
        if (!empty($request->featured_img)) {
            $product->product_img = $request->featured_img;
        }

        $product->product_img_title = $request->product_img_title;
        $product->product_img_alt = $request->product_img_alt;

        // ✅ Handle Product Color Image separately
        if ($request->hasFile('product_color_image')) {
            $file = $request->file('product_color_image');
            $filename = time() . '_' . uniqid() . '.' . $file->getClientOriginalExtension();
            $file->move(public_path('uploads/products'), $filename);
            $product->product_color_image = $filename; // make sure this column exists in DB
        }
        
        
        if ($request->hasFile('brand_logo_image')) {
            $file = $request->file('brand_logo_image');
            $filename = time() . '_' . uniqid() . '.' . $file->getClientOriginalExtension();
            $file->move(public_path('uploads/products'), $filename);
            $product->brand_logo_image = $filename;
        }
        
          // 🆕 Handle Product PDF
        if ($request->hasFile('product_pdf')) {
            $file = $request->file('product_pdf');
            $filename = time().'_'.uniqid().'.'.$file->getClientOriginalExtension();
            $file->move(public_path('uploads/products/pdf'), $filename);
            $product->product_pdf = $filename;
        }

        $product->dated = now();
        $product->save();

        // Sync categories
        if (Schema::hasTable('category_product')) {
            $categoryIds = $request->input('category_ids', []);
            if (!empty($categoryIds) && is_array($categoryIds)) {
                $product->categories()->sync($categoryIds);
            }
        }

        // Update extra images
        $this->updateProductExtraImagesProductIds($request, $product->id);

        // Record update history
        $recordUpdateHistoryData = [
            'record_id' => $product->id,
            'record_title' => $product->product_name,
            'record_link' => url('adminmedia/products/'.$product->id.'/edit'),
            'model_or_table' => 'Product',
            'admin_id' => auth()->user()->id,
            'ip' => request()->ip(),
            'draft' => json_encode($product->toArray()),
        ];
        recordUpdateHistory($recordUpdateHistoryData);

        return json_encode(['status' => true]);
    }

    $html = '';
    foreach ($validator->errors()->all() as $key => $value) {
        $html .= '<li>' . $value . '</li>';
    }
    return json_encode(['status' => false, 'errors' => $html]);
}

public function update(Request $request, $id)
{
    $validator = Validator::make($request->all(), [
        'product_name' => 'required',
        'product_slug' => 'required',
        'product_description' => 'required',
    ]);

    if ($validator->passes()) {
        $product = Product::find($id);

        $product->product_name = $request->product_name;
        $product->product_slug = $request->product_slug;
        $product->product_description = $request->product_description;
        $product->sizes_colors = $request->input('sizes_colors'); // Store HTML
        
        $product->product_vs_id=json_encode($request->product_vs_id) ?? "";

        if (Schema::hasColumn('products', 'slider_description')) {
            $product->slider_description = $request->slider_description;
        }

        // ✅ Keep featured image logic as-is
        if (!empty($request->featured_img)) {
            $product->product_img = $request->featured_img;
        }

        $product->product_img_title = $request->product_img_title;
        $product->product_img_alt = $request->product_img_alt;
        

        $product->meta_title = $request->meta_title;
        $product->meta_keywords = $request->meta_keywords;
        $product->meta_description = $request->meta_description;
        $product->canonical_url = $request->canonical_url;

        // ✅ Handle Product Color Image separately
        if ($request->hasFile('product_color_image')) {
            $file = $request->file('product_color_image');
            $filename = time() . '_' . uniqid() . '.' . $file->getClientOriginalExtension();
            $file->move(public_path('uploads/products'), $filename);
            $product->product_color_image = $filename; // must exist in DB
        }


        if ($request->hasFile('brand_logo_image')) {
            $file = $request->file('brand_logo_image');
            $filename = time() . '_' . uniqid() . '.' . $file->getClientOriginalExtension();
            $file->move(public_path('uploads/products'), $filename);
            $product->brand_logo_image = $filename; // must exist in DB
        }
        
          // 🆕 Replace old PDF if a new one is uploaded
        if ($request->hasFile('product_pdf')) {
            if (!empty($product->product_pdf) && file_exists(public_path('uploads/products/pdf/'.$product->product_pdf))) {
                unlink(public_path('uploads/products/pdf/'.$product->product_pdf));
            }
            $file = $request->file('product_pdf');
            $filename = time().'_'.uniqid().'.'.$file->getClientOriginalExtension();
            $file->move(public_path('uploads/products/pdf'), $filename);
            $product->product_pdf = $filename;
        }



        $product->save();

        // Sync categories if provided
        if (Schema::hasTable('category_product')) {
            $categoryIds = $request->input('category_ids', []);
            if (is_array($categoryIds)) {
                $product->categories()->sync($categoryIds);
            }
        }

        // Update product extra images with product ID
        $this->updateProductExtraImagesProductIds($request, $product->id);

        // Record update history
        $recordUpdateHistoryData = [
            'record_id' => $product->id,
            'record_title' => $product->product_name,
            'record_link' => url('adminmedia/products/'.$product->id.'/edit'),
            'model_or_table' => 'Product',
            'admin_id' => auth()->user()->id,
            'ip' => request()->ip(),
            'draft' => json_encode($product->toArray()),
        ];
        recordUpdateHistory($recordUpdateHistoryData);

        return json_encode(['status' => true]);
    }

    $html = '';
    foreach ($validator->errors()->all() as $key => $value) {
        $html .= '<li>' . $value . '</li>';
    }
    return json_encode(['status' => false, 'errors' => $html]);
}

    /**
     * Display the specified resource.
     *
     * @param int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function show($id, Request $request)
    {
        if ($id == '') {
            echo 'error';
            return;
        }
        $product = Product::find($id);
        $status = $product->sts;
        if ($status == '') {
            echo 'invalid current status provided.';
            return;
        }
        if ($status == 1) {
            $new_status = 0;
        } else {
            $new_status = 1;
        }
        $product->sts = $new_status;
        $product->update();
        /******************************* */
        /******************************* */
        $recordUpdateHistoryData = [
            'record_id' => $product->id,
            'record_title' => $product->product_name,
            'record_link' => url('adminmedia/products/'.$product->id.'/edit'),
            'model_or_table' => 'Product',
            'admin_id' => auth()->user()->id,
            'ip' => request()->ip(),
            'draft' => json_encode($product->toArray()),
        ];
        recordUpdateHistory($recordUpdateHistoryData);
        /******************************* */
        /******************************* */
        echo $new_status;
        return;
    }
    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     *
     * @return \Illuminate\Http\Response
     */
  public function edit($id)
{
    $product = Product::find($id);
    $response = $product ? $product->toArray() : [];

    if ($product && Schema::hasTable('category_product')) {
        $response['selected_category_ids'] = $product->categories()->pluck('id');
    }

    if ($product) {
        $productExtraImages = ProductExtraImage::where('product_id', $product->id)->sorted()->get();
        $response['product_extra_images'] = $productExtraImages;

        // 🆕 Include PDF URL
        $response['product_pdf_url'] = $product->product_pdf 
            ? asset('uploads/products/pdf/'.$product->product_pdf) 
            : null;
            
            $response['sizes_colors'] = $product->sizes_colors ?? '';


        // Existing image debug logic
        $product_img = $product->product_img;
        if (!empty($product_img) && !file_exists(public_path('mlstorage/uploads/products/'.$product_img))) {
            $filename = basename($product_img);
            $extension = pathinfo($filename, PATHINFO_EXTENSION);
            $name = pathinfo($filename, PATHINFO_FILENAME);

            if (preg_match('/^\d+-(.+)$/', $name, $matches)) {
                $baseName = $matches[1];
            } else {
                $baseName = $name;
            }

            $productsDir = public_path('mlstorage/uploads/products/');
            $files = glob($productsDir.'*'.$baseName.'.'.$extension);

            if (!empty($files)) {
                $newFilename = basename($files[0]);
                $product->product_img = $newFilename;
                $product->save();
                $product_img = $newFilename;
            } else {
                $product->product_img = '';
                $product->save();
                $product_img = '';
            }
        }

        $response['debug'] = [
            'product_img' => $product_img,
            'asset_uploads_url' => asset_uploads('products/'.$product_img),
            'file_exists' => file_exists(storage_path('app/public/uploads/products/'.$product_img)),
            'public_file_exists' => file_exists(public_path('mlstorage/uploads/products/'.$product_img)),
        ];

        $response['product_img'] = $product_img;
    }

    return json_encode($response);
}
    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param int                      $id
     *
     * @return \Illuminate\Http\Response
     */
    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Product::destroy($id);
    }

    /**
     * Remove product image via AJAX
     */
    public function ajaxRemoveFeatureImage($id)
    {
        $product = Product::find($id);
        if ($product) {
            $product->product_img = '';
            $product->product_img_title = '';
            $product->product_img_alt = '';
            $product->save();
            
            /******************************* */
            /******************************* */
            $recordUpdateHistoryData = [
                'record_id' => $product->id,
                'record_title' => $product->product_name,
                'record_link' => url('adminmedia/products/'.$product->id.'/edit'),
                'model_or_table' => 'Product',
                'admin_id' => auth()->user()->id,
                'ip' => request()->ip(),
                'draft' => json_encode($product->toArray()),
            ];
            recordUpdateHistory($recordUpdateHistoryData);
            /******************************* */
            /******************************* */
            
            return json_encode(['status' => true]);
        }
        return json_encode(['status' => false]);
    }


    public function productSellStatus(Request $request)
    {
        $product_status = explode(',', $request->product_Sale_Status)[0];
        $id = explode(',', $request->product_Sale_Status)[1];
        $product = Product::where('id', $id)->first();
        if ($product_status == 1) {
            $product->sell_status = 0;
        } else {
            $product->sell_status = 1;
        }
        $product->save();
        /******************************* */
        /******************************* */
        $recordUpdateHistoryData = [
            'record_id' => $product->id,
            'record_title' => $product->product_name,
            'record_link' => url('adminmedia/products/'.$product->id.'/edit'),
            'model_or_table' => 'Product',
            'admin_id' => auth()->user()->id,
            'ip' => request()->ip(),
            'draft' => json_encode($product->toArray()),
        ];
        recordUpdateHistory($recordUpdateHistoryData);
        /******************************* */
        /******************************* */
        return json_encode(['status' => true]);
    }

    /**
     * Get images for media library
     */
    private function get_images()
    {
        $albumsObj = [];
        $folodersArr = [];
        $mediaBasePath = mediaBasePath();
        $folodersArr = array_filter(glob($mediaBasePath . '*'), 'is_dir');
        $cnt = 0;
        // >>>>>>>>>>>>>>>>> **Start** Root Files
        $folderName = 'root';
        $filesArr = getImagesListInDir($mediaBasePath);
        $albumsObj[] = [
            'album_id' => $cnt,
            'album_title' => $folderName,
            'album_path' => $mediaBasePath,
            'album_img' => '',
            'all' => $filesArr,
        ];
        // <<<<<<<<<<<<<<<<< ***End*** Root Files
        foreach ($folodersArr as $key => $folder) {
            ++$cnt;
            $folderName = str_replace($mediaBasePath, '', $folder);
            $currentFolderpath = $mediaBasePath . $folderName . '/';
            $filesArr = getImagesListInDir($currentFolderpath);
            $albumsObj[] = [
                'album_id' => $cnt,
                'album_title' => $folderName,
                'album_path' => $currentFolderpath,
                'album_img' => '',
                'all' => $filesArr,
            ];
        }
        return $albumsObj;
    }

    /**
     * Get files for media library
     */
    private function filesObj()
    {
        $albumsObj = [];
        $folodersArr = [];
        $filesBasePath = filesBasePath();
        $folodersArr = array_filter(glob($filesBasePath . '*'), 'is_dir');
        $cnt = 0;
        // >>>>>>>>>>>>>>>>> **Start** Root Files
        $folderName = 'root';
        $filesArr = getFilesListInDir($filesBasePath, filesExtsAllowed());
        $albumsObj[] = [
            'album_id' => $cnt,
            'album_title' => $folderName,
            'album_path' => $filesBasePath,
            'album_img' => '',
            'all' => $filesArr,
        ];
        // <<<<<<<<<<<<<<<<< ***End*** Root Files
        foreach ($folodersArr as $key => $folder) {
            ++$cnt;
            $folderName = str_replace($filesBasePath, '', $folder);
            $currentFolderpath = $filesBasePath . $folderName . '/';
            $filesArr = getFilesListInDir($currentFolderpath, filesExtsAllowed());
            $albumsObj[] = [
                'album_id' => $cnt,
                'album_title' => $folderName,
                'album_path' => $currentFolderpath,
                'album_img' => '',
                'all' => $filesArr,
            ];
        }
        return $albumsObj;
    }

    /**
     * Upload product extra images
     */
    public function uploadProductExtraImages(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'product_extra_images.*' => 'nullable|image|mimes:jpeg,png,jpg,gif,webp|max:' . getMaxUploadSize() * 1024,
            'product_extra_images_before.*' => 'nullable|image|mimes:jpeg,png,jpg,gif,webp|max:' . getMaxUploadSize() * 1024,
            'product_extra_images_before2.*' => 'nullable|image|mimes:jpeg,png,jpg,gif,webp|max:' . getMaxUploadSize() * 1024,
        ]);

        if ($validator->fails()) {
            return response()->json(['status' => false, 'message' => 'Validation failed', 'errors' => $validator->errors()]);
        }

        $sessionId = uniqid('product_extra_');
        $uploadedImages = [];

        // Handle regular slider images
        if ($request->hasFile('product_extra_images')) {
            foreach ($request->file('product_extra_images') as $imageFile) {
                $fileName = time() . '_' . uniqid() . '.' . $imageFile->getClientOriginalExtension();
                $imageFile->move(public_path('mlstorage/uploads/'), $fileName);

                $imageModel = new ProductExtraImage();
                $imageModel->image_name = $fileName;
                $imageModel->session_id = $sessionId;
                $imageModel->isBeforeAfter = false;
                $imageModel->isBeforeAfterHaveTwoImages = false;
                $imageModel->sort_order = ProductExtraImage::where('session_id', $sessionId)->count() + 1;
                $imageModel->save();

                $uploadedImages[] = $imageModel;
            }
        }

        // Handle before/after images (first set)
        if ($request->hasFile('product_extra_images_before')) {
            foreach ($request->file('product_extra_images_before') as $imageFile) {
                $fileName = time() . '_' . uniqid() . '.' . $imageFile->getClientOriginalExtension();
                $imageFile->move(public_path('mlstorage/uploads/'), $fileName);

                $imageModel = new ProductExtraImage();
                $imageModel->image_name = $fileName;
                $imageModel->session_id = $sessionId;
                $imageModel->isBeforeAfter = true;
                $imageModel->isBeforeAfterHaveTwoImages = false;
                $imageModel->sort_order = ProductExtraImage::where('session_id', $sessionId)->count() + 1;
                $imageModel->save();

                $uploadedImages[] = $imageModel;
            }
        }

        // Handle before/after images (second set)
        if ($request->hasFile('product_extra_images_before2')) {
            foreach ($request->file('product_extra_images_before2') as $imageFile) {
                $fileName = time() . '_' . uniqid() . '.' . $imageFile->getClientOriginalExtension();
                $imageFile->move(public_path('mlstorage/uploads/'), $fileName);

                $imageModel = new ProductExtraImage();
                $imageModel->image_name = $fileName;
                $imageModel->session_id = $sessionId;
                $imageModel->isBeforeAfter = true;
                $imageModel->isBeforeAfterHaveTwoImages = true;
                $imageModel->sort_order = ProductExtraImage::where('session_id', $sessionId)->count() + 1;
                $imageModel->save();

                $uploadedImages[] = $imageModel;
            }
        }

        return response()->json([
            'status' => true,
            'message' => 'successful',
            'session_id' => $sessionId,
            'images' => $uploadedImages
        ]);
    }

    /**
     * Remove product extra image
     */
    public function removeProductExtraImage(Request $request)
    {
        $imageId = $request->input('product_extra_image_id');
        $imageObj = ProductExtraImage::find($imageId);

        if ($imageObj) {
            // Delete physical file
            $filePath = public_path('mlstorage/uploads/') . $imageObj->image_name;
            if (file_exists($filePath)) {
                unlink($filePath);
            }
            
            $imageObj->delete();
            return response()->json(['status' => true, 'message' => 'Image removed successfully']);
        }

        return response()->json(['status' => false, 'message' => 'Image not found']);
    }

    /**
     * Save product extra images sort order
     */
    public function saveProductExtraImagesSortOrder()
    {
        $ids = request()->input('ids', []);
        
        foreach ($ids as $index => $id) {
            $image = ProductExtraImage::find($id);
            if ($image) {
                $image->sort_order = $index + 1;
                $image->save();
            }
        }

        return response()->json(['status' => true, 'message' => 'Sort order updated successfully']);
    }

    /**
     * Get product extra image alt/title
     */
    public function getProductExtraImageAltTitle(Request $request)
    {
        $imageObj = ProductExtraImage::find($request->image_id);
        return response()->json([
            'image_alt' => $imageObj->image_alt ?? '',
            'image_title' => $imageObj->image_title ?? '',
            'image_description' => $imageObj->image_description ?? ''
        ]);
    }

    /**
     * Save product extra image alt/title
     */
    public function saveProductExtraImageAltTitle(Request $request)
    {
        $imageObj = ProductExtraImage::find($request->image_id);
        $imageObj->image_alt = $request->image_alt;
        $imageObj->image_title = $request->image_title;
        $imageObj->image_description = $request->image_description;
        $imageObj->save();

        return response()->json(['status' => true, 'message' => 'Details updated successfully']);
    }

    /**
     * Update product extra images with product ID after product creation
     */
    private function updateProductExtraImagesProductIds($request, $productObjId)
    {
       if ($request->filled('session_id')) {
    ProductExtraImage::where('session_id', $request->session_id)
        ->update([
            'product_id' => $productObjId,
            'session_id' => null
        ]);
}

    }
  public function featured($id){
 
$data=Product::find($id);
        if($data->is_featured=='Yes')
        {
            $data->is_featured='No';
            $response_array=['status'=>'success','res'=>0];
        }
        else{
            $data->is_featured='Yes'; 
            $response_array=['status'=>'success','res'=>1];
 
        }
        $data->save();
       
       return response()->json($response_array);
    }  
    
    
    
}
