<?php

use App\Models\Back\ProductExtraImage;

if (!function_exists('getProductSliderImages')) {
    function getProductSliderImages($productId)
    {
        return ProductExtraImage::where('product_id', $productId)
            ->where(function ($q) {
                $q->whereNull('isBeforeAfter')->orWhere('isBeforeAfter', false);
            })
            ->sorted()
            ->get();
    }
}

if (!function_exists('getProductBeforeAfterImages')) {
    function getProductBeforeAfterImages($productId)
    {
        return ProductExtraImage::where('product_id', $productId)
            ->where('isBeforeAfter', true)
            ->sorted()
            ->get();
    }
}

if (!function_exists('productExtraImageUrl')) {
    function productExtraImageUrl($imageName)
    {
        if (!$imageName) {
            return '';
        }
        return asset_uploads($imageName);
    }
}

